/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PigeonEnterPigeonholeGoal
extends Goal {
    private final Pigeon pigeon;

    public PigeonEnterPigeonholeGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public boolean canUse() {
        BlockEntity blockEntity;
        if (this.pigeon.isDelivering()) {
            return false;
        }
        @Nullable BlockPos pos = this.pigeon.getPigeonholeHandler().getTargetPos();
        if (pos != null && this.pigeon.getPigeonholeHandler().wantsToEnterPigeonhole(this.pigeon) && pos.closerToCenterThan((net.minecraft.core.Position)this.pigeon.position(), 2.0) && !Position.isFireNearby(this.pigeon.level(), pos) && (blockEntity = this.pigeon.level().getBlockEntity(pos)) instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity blockEntity2 = (PigeonholeBlockEntity)blockEntity;
            if (blockEntity2.hasSpaceForAnotherOccupant()) {
                return true;
            }
            this.pigeon.getPigeonholeHandler().setTargetPos(null);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.pigeon.getPigeonholeHandler().getPigeonholeAtCurrentPos(this.pigeon.level()).ifPresent(pigeonhole -> pigeonhole.addOccupant(pigeonhole.getBlockPos(), pigeonhole.getBlockState(), (Entity)this.pigeon));
    }
}

