/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.entity.ai.MailboxHandler;
import io.github.mortuusars.envelope.world.entity.ai.goal.AbstractGoToBlockGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class PigeonGoToMailboxGoal
extends AbstractGoToBlockGoal {
    @Nullable
    protected Path lastPath;

    public PigeonGoToMailboxGoal(Pigeon pigeon) {
        super(pigeon);
    }

    @Override
    @Nullable
    public BlockPos getBlockPos() {
        return this.pigeon.getMailboxHandler().getTargetPos();
    }

    @Override
    public boolean canUse() {
        MailboxBlockEntity blockEntity;
        BlockEntity blockEntity2;
        return !this.pigeon.isDelivering() && this.pigeon.canStartDelivery() && super.canUse() && (blockEntity2 = this.pigeon.level().getBlockEntity(this.getBlockPos())) instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)blockEntity2).isAvailableForPickup();
    }

    public void tick() {
        MailboxHandler handler = this.pigeon.getMailboxHandler();
        if (handler.getTargetPos() == null) {
            return;
        }
        ++this.travellingTicks;
        if (this.travellingTicks > this.adjustedTickDelay(600)) {
            handler.dropAndBlacklistMailbox();
            return;
        }
        if (this.pigeon.getNavigation().isInProgress()) {
            return;
        }
        if (!this.pigeon.closerThan(handler.getTargetPos(), 16)) {
            if (!this.pigeon.blockPosition().closerThan((Vec3i)handler.getTargetPos(), 32.0)) {
                handler.dropMailbox();
            } else {
                this.pigeon.pathfindRandomlyTowards(handler.getTargetPos());
            }
        } else {
            boolean canReach = this.pigeon.pathfindDirectlyTowards(handler.getTargetPos());
            if (!canReach) {
                handler.dropAndBlacklistMailbox();
            } else if (this.lastPath != null && this.lastPath.sameAs(this.pigeon.getNavigation().getPath())) {
                ++this.ticksStuck;
                if (this.ticksStuck > 60) {
                    handler.dropMailbox();
                    this.ticksStuck = 0;
                }
            } else {
                this.lastPath = this.pigeon.getNavigation().getPath();
            }
        }
    }
}

