/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.entity.ai.PigeonholeHandler;
import io.github.mortuusars.envelope.world.entity.ai.goal.AbstractGoToBlockGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class PigeonGoToPigeonholeGoal
extends AbstractGoToBlockGoal {
    @Nullable
    protected Path lastPath;

    public PigeonGoToPigeonholeGoal(Pigeon pigeon) {
        super(pigeon);
    }

    @Override
    @Nullable
    public BlockPos getBlockPos() {
        return this.pigeon.getPigeonholeHandler().getTargetPos();
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.pigeon.getPigeonholeHandler().wantsToEnterPigeonhole(this.pigeon) && this.pigeon.level().getBlockState(this.pigeon.getPigeonholeHandler().getTargetPos()).is(Envelope.Tags.Blocks.PIGEONHOLES) && !Position.isFireNearby(this.pigeon.level(), this.pigeon.getPigeonholeHandler().getTargetPos());
    }

    public void tick() {
        PigeonholeHandler handler = this.pigeon.getPigeonholeHandler();
        if (handler.getTargetPos() == null) {
            return;
        }
        ++this.travellingTicks;
        if (this.travellingTicks > this.adjustedTickDelay(600)) {
            handler.dropAndBlacklistPigeonhole();
            return;
        }
        if (this.pigeon.getNavigation().isInProgress()) {
            return;
        }
        if (!this.pigeon.closerThan(handler.getTargetPos(), 16)) {
            if (!this.pigeon.blockPosition().closerThan((Vec3i)handler.getTargetPos(), 32.0)) {
                handler.dropPigeonhole();
            } else {
                this.pigeon.pathfindRandomlyTowards(handler.getTargetPos());
            }
        } else {
            boolean canReach = this.pigeon.pathfindDirectlyTowards(handler.getTargetPos());
            if (!canReach) {
                handler.dropAndBlacklistPigeonhole();
            } else if (this.lastPath != null && this.lastPath.sameAs(this.pigeon.getNavigation().getPath())) {
                ++this.ticksStuck;
                if (this.ticksStuck > 60) {
                    handler.dropPigeonhole();
                    this.ticksStuck = 0;
                }
            } else {
                this.lastPath = this.pigeon.getNavigation().getPath();
            }
        }
    }
}

