/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PigeonLocateMailboxGoal
extends Goal {
    protected final Pigeon pigeon;

    public PigeonLocateMailboxGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        return MailService.operatesIn(this.pigeon.level()) && !this.pigeon.isDelivering() && this.pigeon.canStartDelivery() && this.pigeon.getMailboxHandler().getLocateCooldown() <= 0 && this.pigeon.getMailboxHandler().getTargetPos() == null && (double)this.pigeon.level().getRandom().nextFloat() < 0.05;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.pigeon.getMailboxHandler().resetLocateCooldown();
        List<BlockPos> mailboxes = this.findNearbyAvailableMailboxes();
        if (!mailboxes.isEmpty()) {
            for (BlockPos pos : mailboxes) {
                if (this.pigeon.getMailboxHandler().isTargetBlacklisted(pos)) continue;
                this.pigeon.getMailboxHandler().setTargetPos(pos);
                return;
            }
            this.pigeon.getMailboxHandler().clearBlacklist();
            this.pigeon.getMailboxHandler().setTargetPos(mailboxes.getFirst());
        }
    }

    private List<BlockPos> findNearbyAvailableMailboxes() {
        BlockPos pos = this.pigeon.blockPosition();
        PoiManager poiManager = ((ServerLevel)this.pigeon.level()).getPoiManager();
        return poiManager.getInRange(holder -> holder.is(Envelope.PoiTypes.MAILBOX), pos, 20, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(p -> {
            MailboxBlockEntity mailbox;
            BlockEntity patt0$temp = this.pigeon.level().getBlockEntity(p);
            return patt0$temp instanceof MailboxBlockEntity && (mailbox = (MailboxBlockEntity)patt0$temp).isAvailableForPickup();
        }).sorted(Comparator.comparingDouble(p -> p.distSqr((Vec3i)pos))).collect(Collectors.toList());
    }
}

