/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PigeonLocatePigeonholeGoal
extends Goal {
    protected final Pigeon pigeon;

    public PigeonLocatePigeonholeGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public boolean canUse() {
        return MailService.operatesIn(this.pigeon.level()) && this.pigeon.getPigeonholeHandler().getLocateCooldown() == 0 && this.pigeon.getPigeonholeHandler().getTargetPos() == null && this.pigeon.getPigeonholeHandler().wantsToEnterPigeonhole(this.pigeon);
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.pigeon.getPigeonholeHandler().resetLocateCooldown();
        List<BlockPos> pigeonholes = this.findNearbyPigeonholesWithSpace();
        if (!pigeonholes.isEmpty()) {
            for (BlockPos pos : pigeonholes) {
                if (this.pigeon.getPigeonholeHandler().isTargetBlacklisted(pos)) continue;
                this.pigeon.getPigeonholeHandler().setTargetPos(pos);
                return;
            }
            this.pigeon.getPigeonholeHandler().clearBlacklist();
            this.pigeon.getPigeonholeHandler().setTargetPos(pigeonholes.getFirst());
        }
    }

    private List<BlockPos> findNearbyPigeonholesWithSpace() {
        BlockPos pos = this.pigeon.blockPosition();
        PoiManager poiManager = ((ServerLevel)this.pigeon.level()).getPoiManager();
        return poiManager.getInRange(holder -> holder.is(Envelope.PoiTypes.PIGEONHOLE), pos, 20, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(p -> {
            PigeonholeBlockEntity pigeonhole;
            BlockEntity patt0$temp = this.pigeon.level().getBlockEntity(p);
            return patt0$temp instanceof PigeonholeBlockEntity && (pigeonhole = (PigeonholeBlockEntity)patt0$temp).hasSpaceForAnotherOccupant();
        }).sorted(Comparator.comparingDouble(p -> p.distSqr((Vec3i)pos))).collect(Collectors.toList());
    }
}

