/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.entity.Pigeon;
import net.minecraft.world.entity.ai.goal.Goal;

public class PigeonSitGoal
extends Goal {
    private final Pigeon pigeon;
    private int time;
    private long cooldownUntil;

    public PigeonSitGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        return !this.pigeon.isDelivering() && this.pigeon.isTired() && this.pigeon.getTiredTicks() > 100 && !this.pigeon.isPanicking() && this.pigeon.onGround() && this.pigeon.level().getGameTime() >= this.cooldownUntil && this.pigeon.getRandom().nextInt(20) == 0;
    }

    public boolean canContinueToUse() {
        return this.pigeon.isTired() && this.pigeon.isSitting() && this.time < 600;
    }

    public void start() {
        this.pigeon.setSitting(true);
        this.time = 0;
    }

    public void stop() {
        this.pigeon.setSitting(false);
        this.cooldownUntil = this.pigeon.level().getGameTime() + 100L;
    }

    public void tick() {
        if (this.pigeon.isSitting()) {
            ++this.time;
        }
    }
}

