/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PigeonStartDeliveryFromMailboxGoal
extends Goal {
    private final Pigeon pigeon;

    public PigeonStartDeliveryFromMailboxGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public boolean canUse() {
        MailboxBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (!MailService.operatesIn(this.pigeon.level()) || this.pigeon.isDelivering() || !this.pigeon.canStartDelivery()) {
            return false;
        }
        @Nullable BlockPos pos = this.pigeon.getMailboxHandler().getTargetPos();
        return pos != null && pos.closerToCenterThan((Position)this.pigeon.position(), 2.0) && (blockEntity2 = this.pigeon.level().getBlockEntity(pos)) instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)blockEntity2).isAvailableForPickup();
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.pigeon.getMailboxHandler().getMailboxAtCurrentPos(this.pigeon.level()).ifPresent(blockEntity -> {
            blockEntity.tryStartDelivery(this.pigeon);
            this.pigeon.getMailboxHandler().setTargetPos(null);
        });
    }
}

