/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PigeonWanderGoal
extends Goal {
    private static final int WANDER_THRESHOLD = 22;
    private final Pigeon pigeon;

    public PigeonWanderGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return !this.pigeon.isSitting() && this.pigeon.getNavigation().isDone() && this.pigeon.getRandom().nextInt(25) == 0;
    }

    public boolean canContinueToUse() {
        return this.pigeon.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 pos = this.findPos();
        if (pos != null) {
            this.pigeon.getNavigation().moveTo(this.pigeon.getNavigation().createPath(BlockPos.containing((Position)pos), 1), 1.0);
        }
    }

    @Nullable
    private Vec3 findPos() {
        Vec3 pos;
        @Nullable BlockPos pigeonholePos = this.pigeon.getPigeonholeHandler().getTargetPos();
        if (this.pigeon.getPigeonholeHandler().isPigeonholeValid(this.pigeon.level(), this.pigeon.blockPosition()) && pigeonholePos != null && !this.pigeon.closerThan(pigeonholePos, 22)) {
            Vec3 pigeonholeCenter = Vec3.atCenterOf((Vec3i)pigeonholePos);
            pos = pigeonholeCenter.subtract(this.pigeon.position()).normalize();
        } else {
            pos = this.pigeon.getViewVector(0.0f);
        }
        int radius = 8;
        Vec3 hoverPos = HoverRandomPos.getPos((PathfinderMob)this.pigeon, (int)radius, (int)12, (double)pos.x, (double)pos.z, (float)1.5707964f, (int)3, (int)1);
        return hoverPos != null ? hoverPos : AirAndWaterRandomPos.getPos((PathfinderMob)this.pigeon, (int)radius, (int)4, (int)-2, (double)pos.x, (double)pos.z, (double)1.5707963705062866);
    }
}

