/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.spawner;

import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.TransitionableCourier;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundDelivery;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BackgroundCourierSpawner
implements CustomSpawner {
    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        BackgroundDelivery backgroundDelivery = MailService.of(level).getBackgroundDelivery();
        List<BackgroundCourier> spawnableCouriers = backgroundDelivery.getCouriers().stream().filter(this::canSpawn).toList();
        if (spawnableCouriers.isEmpty()) {
            return 0;
        }
        BackgroundCourier courier = (BackgroundCourier)Util.getRandom(spawnableCouriers, (RandomSource)level.getRandom());
        this.trySpawn(level, courier);
        return 0;
    }

    private boolean canSpawn(BackgroundCourier courier) {
        if (courier.getOrigin().isService() && courier.getDelivery().getMail().isEmpty() && !courier.getDelivery().getPhase().isOnRecipientSide()) {
            return false;
        }
        return courier.getDelivery().getPhase().isSpawnable();
    }

    protected void trySpawn(ServerLevel level, BackgroundCourier backgroundCourier) {
        Delivery delivery = backgroundCourier.getDelivery();
        int duration = backgroundCourier.getPhaseDuration(level, delivery, delivery.getPhase());
        int progress = delivery.getPhaseProgress();
        float completeness = Mth.clamp((float)((float)progress / (float)duration), (float)0.0f, (float)1.0f);
        delivery.getRoute().getSegment(delivery.getPhase()).getCurrentLocation(completeness).filter(arg_0 -> ((ServerLevel)level).isLoaded(arg_0)).map(pos -> Position.aboveGround((Level)level, pos, 2)).filter(pos -> Position.isInSimulationDistance(level, pos)).ifPresent(pos -> {
            @Nullable Entity entity = backgroundCourier.getEntityData().createEntity(level);
            if (entity instanceof TransitionableCourier) {
                TransitionableCourier courier = (TransitionableCourier)entity;
                entity.moveTo(pos, entity.getYRot(), entity.getXRot());
                level.addFreshEntityWithPassengers(entity);
                courier.onAppeared(level);
                courier.setDelivery(delivery);
                MailService.of(level).getBackgroundDelivery().removeCourier(backgroundCourier);
            }
        });
    }
}

