/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.spawner;

import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundDelivery;
import io.github.mortuusars.envelope.world.delivery.background.FinishedBackgroundCourier;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CustomSpawner;
import org.jetbrains.annotations.Nullable;

public class FinishedBackgroundCourierSpawner
implements CustomSpawner {
    protected static final int SPAWN_ATTEMPT_DELAY = 10;
    protected int nextAttemptDelay;

    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        --this.nextAttemptDelay;
        if (this.nextAttemptDelay > 0) {
            return 0;
        }
        this.nextAttemptDelay = 10;
        BackgroundDelivery backgroundDelivery = MailService.of(level).getBackgroundDelivery();
        List<FinishedBackgroundCourier> couriers = backgroundDelivery.getFinishedCouriers();
        if (couriers.isEmpty()) {
            return 0;
        }
        FinishedBackgroundCourier courier = (FinishedBackgroundCourier)Util.getRandom(couriers, (RandomSource)level.getRandom());
        @Nullable BlockPos spawnPos = Position.findNearbyHeightmapSpawnPosition(level, courier.spawnPos(), 2);
        if (spawnPos == null) {
            return 0;
        }
        @Nullable Entity entity = courier.entityData().createEntity(level);
        if (entity == null) {
            return 0;
        }
        entity.moveTo(spawnPos, entity.getYRot(), entity.getXRot());
        level.addFreshEntityWithPassengers(entity);
        if (!courier.undeliveredMail().isEmpty()) {
            entity.spawnAtLocation(courier.undeliveredMail());
        }
        backgroundDelivery.removeFinishedCourier(courier);
        return 0;
    }
}

