/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.spawner;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class PigeonSpawner
implements CustomSpawner {
    protected static final int SPAWN_ATTEMPT_DELAY = 1000;
    protected int nextAttemptDelay;

    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnFriendlies || !level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        --this.nextAttemptDelay;
        if (this.nextAttemptDelay > 0) {
            return 0;
        }
        this.nextAttemptDelay = 1000;
        ServerPlayer player = level.getRandomPlayer();
        if (player == null) {
            return 0;
        }
        RandomSource randomSource = level.random;
        int x = (8 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        int y = (8 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        BlockPos spawnPos = player.blockPosition().offset(x, 0, y);
        if (!level.isLoaded(spawnPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, spawnPos))) {
            return 0;
        }
        if (SpawnPlacements.isSpawnPositionOk(Envelope.EntityTypes.PIGEON.get(), (LevelReader)level, (BlockPos)spawnPos)) {
            if (((Boolean)Config.Server.PIGEON_SPAWNS_IN_VILLAGE.get()).booleanValue() && level.isCloseToVillage(spawnPos, 2)) {
                return this.spawnInVillage(level, spawnPos);
            }
            if (level.structureManager().getStructureWithPieceAt(spawnPos, Envelope.Tags.Structures.PIGEONS_SPAWN_IN).isValid()) {
                return this.spawnInStructure(level, spawnPos);
            }
        }
        return 0;
    }

    protected int spawnInVillage(ServerLevel serverLevel, BlockPos pos) {
        List pigeonsInArea;
        int area = 48;
        if (serverLevel.getPoiManager().getCountInRange(holder -> holder.is(PoiTypes.HOME), pos, area, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (pigeonsInArea = serverLevel.getEntitiesOfClass(Pigeon.class, new AABB(pos).inflate((double)area, 8.0, (double)area))).size() < 5) {
            return this.spawn(serverLevel, pos);
        }
        return 0;
    }

    protected int spawnInStructure(ServerLevel serverLevel, BlockPos pos) {
        int area = 16;
        List list = serverLevel.getEntitiesOfClass(Pigeon.class, new AABB(pos).inflate((double)area, 8.0, (double)area));
        return list.isEmpty() ? this.spawn(serverLevel, pos) : 0;
    }

    protected int spawn(ServerLevel level, BlockPos pos) {
        @Nullable Pigeon pigeon = (Pigeon)Envelope.EntityTypes.PIGEON.get().create((Level)level);
        if (pigeon == null) {
            return 0;
        }
        pigeon.moveTo(pos, 0.0f, 0.0f);
        pigeon.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.NATURAL, null);
        level.addFreshEntityWithPassengers((Entity)pigeon);
        level.playSound(null, (Entity)pigeon, Envelope.SoundEvents.PIGEON_AMBIENT.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
        return 1;
    }
}

