/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxMenuMailRemovedS2CP;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxMenuSetMailS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.inventory.PlayerInventoryUtil;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailboxMenu
extends AbstractContainerMenu {
    public static final int ADDRESS_BUTTON_ID = 0;
    public static final int REFRESH_MAIL_BUTTON_ID = 1;
    protected final DataSlot hasDefault = DataSlot.standalone();
    protected final DataSlot isDefault = DataSlot.standalone();
    protected final Inventory playerInventory;
    protected final Player player;
    protected final BlockPos pos;
    protected final Address.Block address;
    protected final MailboxBlockEntity blockEntity;
    protected List<ItemStack> mail;
    protected boolean hasNewMail;

    protected MailboxMenu(@Nullable MenuType<?> menuType, int id, Inventory playerInventory, BlockPos pos, Address.Block address, List<ItemStack> mail) {
        super(menuType, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.player;
        this.pos = pos;
        this.address = address;
        BlockEntity blockEntity = playerInventory.player.level().getBlockEntity(pos);
        if (!(blockEntity instanceof MailboxBlockEntity)) {
            throw new IllegalStateException("MailboxBlockEntity is not available at " + String.valueOf(pos));
        }
        final MailboxBlockEntity be = (MailboxBlockEntity)blockEntity;
        this.blockEntity = be;
        this.setMail(mail);
        this.addSlot(new Slot(this, (Container)be, 0, 201, 37){

            public boolean mayPlace(ItemStack stack) {
                return be.canPlaceItem(0, stack);
            }
        });
        this.addSlot(new Slot(this, (Container)be, 1, 222, 37){

            public boolean mayPlace(ItemStack stack) {
                return be.canPlaceItem(1, stack);
            }
        });
        this.addPlayerSlots(playerInventory, 140, 88);
        this.addDataSlot(this.hasDefault);
        this.addDataSlot(this.isDefault);
        this.updateHasDefault();
        this.updateIsDefault();
    }

    public MailboxMenu(int id, Inventory playerInventory, BlockPos pos, Address.Block address, List<ItemStack> mail) {
        this(Envelope.MenuTypes.PIGEONHOLE.get(), id, playerInventory, pos, address, mail);
    }

    public static MailboxMenu fromNetwork(int id, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        BlockPos mailboxPos = buffer.readBlockPos();
        Address.Block address = (Address.Block)Address.Block.STREAM_CODEC.decode((Object)buffer);
        List mail = (List)ItemStack.LIST_STREAM_CODEC.decode((Object)buffer);
        return new MailboxMenu(id, inventory, mailboxPos, address, mail);
    }

    public boolean stillValid(Player player) {
        return this.getBlockEntity().stillValid(player) && this.getBlockEntity().getAddress().equals(this.address);
    }

    public BlockPos getBlockPosition() {
        return this.pos;
    }

    public MailboxBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean hasDefaultAddress() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.serverLevel().getEnvelopeMailService().getPlayers().getDefaultAddressOf(this.player).isPresent();
        }
        return this.hasDefault.get() == 1;
    }

    protected void updateHasDefault() {
        if (this.player instanceof ServerPlayer) {
            this.hasDefault.set(this.hasDefaultAddress() ? 1 : 0);
        }
    }

    public boolean isDefaultAddress() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.serverLevel().getEnvelopeMailService().getPlayers().getDefaultAddressOf(this.player).map(this.address::equals).orElse(false);
        }
        return this.isDefault.get() == 1;
    }

    protected void updateIsDefault() {
        if (this.player instanceof ServerPlayer) {
            this.isDefault.set(this.isDefaultAddress() ? 1 : 0);
        }
    }

    public List<ItemStack> getMail() {
        return this.mail;
    }

    public void setMail(List<ItemStack> mail) {
        this.mail = new ArrayList<ItemStack>(mail.reversed());
        this.setHasNewMail(false);
    }

    public boolean hasNewMail() {
        return this.hasNewMail;
    }

    public void setHasNewMail(boolean hasNewMail) {
        this.hasNewMail = hasNewMail;
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)playerInventory, slot, x + slot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18));
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack clickedStack = slot.getItem();
        ItemStack returnedStack = clickedStack.copy();
        if (index < 2 ? !this.moveItemStackTo(clickedStack, 2, this.slots.size(), true) : index < this.slots.size() && !this.moveItemStackTo(clickedStack, 0, 2, false)) {
            return ItemStack.EMPTY;
        }
        if (clickedStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return returnedStack;
    }

    public boolean doMailAction(Player player, int index, MailAction action) {
        if (index < 0 || index >= this.getMail().size()) {
            return false;
        }
        return switch (action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.pickUpMail(player, index);
            case 1 -> this.moveMailToInventory(player, index);
            case 2 -> this.moveAllMailToInventory(player);
        };
    }

    protected boolean pickUpMail(Player player, int index) {
        if (!this.getCarried().isEmpty()) {
            return false;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setCarried(this.extractMail(serverLevel, index));
        }
        return true;
    }

    protected boolean moveMailToInventory(Player player, int index) {
        ServerLevel serverLevel;
        ItemStack taken;
        ItemStack mail = this.getMail().get(index).copy();
        if (!PlayerInventoryUtil.canAddWholeStack(player, mail)) {
            return false;
        }
        Level level = player.level();
        if (level instanceof ServerLevel && !(taken = this.extractMail(serverLevel = (ServerLevel)level, index)).isEmpty()) {
            player.getInventory().add(taken);
        }
        return true;
    }

    protected boolean moveAllMailToInventory(Player player) {
        boolean movedSomething = false;
        while (!this.getMail().isEmpty()) {
            if (!this.moveMailToInventory(player, 0)) {
                return movedSomething;
            }
            movedSomething = true;
        }
        return true;
    }

    protected ItemStack extractMail(ServerLevel level, int index) {
        return Optional.ofNullable(Mail.getId(this.getMail().get(index))).map(id -> this.getBlockEntity().removeMail((Id)id)).orElse(ItemStack.EMPTY);
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.serverLevel().getEnvelopeMailService().getPlayers().setDefaultAddress(player, this.address);
            this.updateHasDefault();
            this.updateIsDefault();
            return true;
        }
        if (id == 1 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<ItemStack> mail = this.getBlockEntity().getAllMail();
            this.setMail(mail);
            Packets.sendToClient(new MailboxMenuSetMailS2CP(mail), serverPlayer);
            return true;
        }
        return false;
    }

    public static List<ServerPlayer> playersWithMenu(ServerLevel level, @Nullable Address.Block address) {
        return level.players().stream().filter(pl -> {
            MailboxMenu menu;
            AbstractContainerMenu patt0$temp = pl.containerMenu;
            return patt0$temp instanceof MailboxMenu && (menu = (MailboxMenu)patt0$temp).getAddress().equals(address);
        }).toList();
    }

    public static void executeForPlayersWithMenu(ServerLevel level, @Nullable Address.Block address, BiConsumer<ServerPlayer, MailboxMenu> action) {
        MailboxMenu.playersWithMenu(level, address).forEach(pl -> action.accept((ServerPlayer)pl, (MailboxMenu)pl.containerMenu));
    }

    public void onMailRemoved(Id id) {
        this.getMail().removeIf(m -> id.equals(Mail.getId(m)));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Packets.sendToClient(new MailboxMenuMailRemovedS2CP(id), serverPlayer);
        }
    }

    public static enum MailAction {
        PICK_UP,
        MOVE_TO_INVENTORY,
        MOVE_ALL_TO_INVENTORY;

        public static final StreamCodec<ByteBuf, MailAction> STREAM_CODEC;

        static {
            STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])MailAction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
        }
    }
}

