/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.item.PackingBox;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackingMenu
extends AbstractContainerMenu {
    public static final int PACK_BUTTON_ID = 0;
    private final Player player;
    private final InteractionHand hand;
    private final int packageSlot;
    private final ItemStack packageStack;
    private final PackingBox packingBox;
    private final PackageContents initialPackageContents;
    private final boolean canPack;
    private final SimpleContainer packageContainer;
    protected boolean packed = false;

    protected PackingMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, InteractionHand hand) {
        super(menuType, containerId);
        this.player = playerInventory.player;
        this.hand = hand;
        this.packageSlot = hand == InteractionHand.OFF_HAND ? 40 : playerInventory.selected;
        this.packageStack = playerInventory.getItem(this.packageSlot);
        this.packingBox = (PackingBox)this.packageStack.getItem();
        this.initialPackageContents = PackageContents.from(this.packageStack);
        this.canPack = this.packingBox.canPack(this.packageStack);
        this.packageContainer = this.createPackageContainer();
        this.init();
    }

    public PackingMenu(int containerId, Inventory playerInventory, InteractionHand hand) {
        this(Envelope.MenuTypes.PACKAGE.get(), containerId, playerInventory, hand);
    }

    public static PackingMenu fromNetwork(int id, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        return new PackingMenu(id, inventory, (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    protected void init() {
        this.addPackageSlots();
        this.addPlayerSlots((Container)this.player.getInventory(), 8, 96, this.packageSlot);
    }

    @NotNull
    protected SimpleContainer createPackageContainer() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(PackageContents.from(this.packageStack).copyItems());
        while (items.size() < 6) {
            items.add(ItemStack.EMPTY);
        }
        SimpleContainer packageContainer = new SimpleContainer((ItemStack[])items.toArray(ItemStack[]::new));
        return packageContainer;
    }

    protected void addPackageSlots() {
        int packageSlotsX = 62;
        int packageSlotsY = 33;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 3;
                int x = packageSlotsX + column * 18;
                int y = packageSlotsY + row * 18;
                this.addSlot(new Slot((Container)this.packageContainer, index, x, y){

                    public boolean mayPlace(ItemStack stack) {
                        return PackingMenu.this.getPackage().canInsert(stack);
                    }
                });
            }
        }
    }

    protected void addPlayerSlots(Container inventory, int x, int y, int packageSlot) {
        for (int index = 0; index < 9; ++index) {
            int slotX = x + index * 18;
            int slotY = y + 58;
            this.addSlot(index == packageSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new Slot(inventory, index, slotX, slotY));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                int slotX = x + column * 18;
                int slotY = y + row * 18;
                this.addSlot(index == packageSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new Slot(inventory, index, slotX, slotY));
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public int getPackageSlot() {
        return this.packageSlot;
    }

    public ItemStack getBoxStack() {
        return this.packageStack;
    }

    public PackingBox getPackage() {
        return this.packingBox;
    }

    public PackageContents getInitialPackageContents() {
        return this.initialPackageContents;
    }

    @NotNull
    protected PackageContents getPackageContentsFromItem() {
        return PackageContents.from(this.getBoxStack());
    }

    public boolean canPack() {
        return this.canPack;
    }

    public SimpleContainer getPackageContainer() {
        return this.packageContainer;
    }

    public boolean needsPacking() {
        if (this.packed) {
            return false;
        }
        PackageContents contents = PackageContents.createFrom((Container)this.packageContainer);
        return !contents.isEmpty();
    }

    public boolean isContainerEmpty() {
        return this.packageContainer.isEmpty();
    }

    public boolean isPackageDestroyedOnClose() {
        return !this.canPack && (this.needsPacking() || this.isContainerEmpty());
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        ItemStack clickedStack = slot.getItem();
        if (index < 6 ? !this.moveItemStackTo(clickedStack, 6, this.slots.size(), true) : index < this.slots.size() && !this.moveItemStackTo(clickedStack, 0, 6, false)) {
            return ItemStack.EMPTY;
        }
        this.packageContainer.setChanged();
        return ItemStack.EMPTY;
    }

    public boolean clickMenuButton(@NotNull Player player, int buttonId) {
        if (buttonId == 0 && this.canPack()) {
            this.pack(player);
            return true;
        }
        return false;
    }

    protected void pack(@NotNull Player player) {
        ItemStack stack = this.createPackingResult();
        stack.set(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)PackageContents.createFrom((Container)this.packageContainer));
        stack.set(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)((Integer)stack.getOrDefault(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)0) + 1));
        player.setItemInHand(this.getHand(), stack);
        player.level().playSound(null, (Entity)player, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, player.level().getRandom().nextFloat() * 0.3f + 0.85f);
        this.packed = true;
    }

    protected ItemStack createPackingResult() {
        ItemStack stack = this.getBoxStack().transmuteCopy((ItemLike)Envelope.Items.PACKAGE.get());
        Mail.removePreviousDeliveryData(stack);
        return stack;
    }

    public void removed(@NotNull Player player) {
        if (!this.packed && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ItemStack stack : PackageContents.createFrom((Container)this.packageContainer).copyItems()) {
                player.drop(stack, true);
            }
            this.getBoxStack().remove(Envelope.DataComponents.PACKAGE_CONTENTS);
            if (this.getPackage().shouldBeDestroyedWhenEmpty(this.getBoxStack())) {
                player.getItemInHand(this.hand).shrink(1);
                serverPlayer.serverLevel().playSound(null, (Entity)serverPlayer, SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).getItem() instanceof PackingBox;
    }
}

