/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.ItemAndStack;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.inventory.slot.FilteredSlot;
import io.github.mortuusars.envelope.world.item.PaybackTagItem;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaybackTagMenu
extends AbstractContainerMenu {
    public static final int CONFIRM_BUTTON_ID = 0;
    public static final int COUNT_START_BUTTON_ID = 100;
    public static final int INCREASE_COUNT_START_BUTTON_ID = 100;
    public static final int INCREASE_COUNT_FAST_START_BUTTON_ID = 106;
    public static final int DECREASE_COUNT_START_BUTTON_ID = 112;
    public static final int DECREASE_COUNT_FAST_START_BUTTON_ID = 118;
    private final Player player;
    private final InteractionHand hand;
    private final int tagSlot;
    private final ItemAndStack<Item> tagStack;
    private final SimpleContainer paybackContainer;

    protected PaybackTagMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, InteractionHand hand) {
        super(menuType, containerId);
        this.player = playerInventory.player;
        this.hand = hand;
        this.tagSlot = hand == InteractionHand.OFF_HAND ? 40 : playerInventory.selected;
        this.tagStack = new ItemAndStack(playerInventory.getItem(this.tagSlot));
        this.paybackContainer = this.createPaybackContainer();
        this.addPaybackSlots();
        this.addPlayerSlots((Container)playerInventory, 13, 72, this.tagSlot);
    }

    public PaybackTagMenu(int containerId, Inventory playerInventory, InteractionHand hand) {
        this(Envelope.MenuTypes.PAYBACK_TAG.get(), containerId, playerInventory, hand);
    }

    public static PaybackTagMenu fromNetwork(int id, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        return new PaybackTagMenu(id, inventory, (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    protected SimpleContainer createPaybackContainer() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        @Nullable PaybackTagContents paybackTagContents = (PaybackTagContents)this.tagStack.get(Envelope.DataComponents.PAYBACK_TAG_CONTENTS);
        if (paybackTagContents != null) {
            for (int i = 0; i < Math.min(paybackTagContents.size(), 6); ++i) {
                items.add(paybackTagContents.getItemForReading(i));
            }
        }
        while (items.size() < 6) {
            items.add(ItemStack.EMPTY);
        }
        return new SimpleContainer((ItemStack[])items.toArray(ItemStack[]::new));
    }

    protected void addPaybackSlots() {
        int slotsX = 67;
        int slotsY = 20;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 3;
                int x = slotsX + column * 18;
                int y = slotsY + row * 18;
                this.addSlot(new FilteredSlot((Container)this.paybackContainer, index, x, y, RequestedPayback::isValidPaybackItem));
            }
        }
    }

    protected void addPlayerSlots(Container inventory, int x, int y, int tagSlot) {
        for (int index = 0; index < 9; ++index) {
            int slotX = x + index * 18;
            int slotY = y + 58;
            this.addSlot(index == tagSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new Slot(inventory, index, slotX, slotY));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                int slotX = x + column * 18;
                int slotY = y + row * 18;
                this.addSlot(index == tagSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new Slot(inventory, index, slotX, slotY));
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public int getTagSlot() {
        return this.tagSlot;
    }

    public ItemAndStack<Item> getTag() {
        return this.tagStack;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        ItemStack clickedStack = slot.getItem();
        if (index < 6) {
            this.paybackContainer.setItem(index, ItemStack.EMPTY);
            this.paybackContainer.setChanged();
        } else if (index < this.slots.size()) {
            for (int i = 0; i < 6; ++i) {
                Slot paybackSlot = (Slot)this.slots.get(i);
                if (!paybackSlot.getItem().isEmpty() || !paybackSlot.mayPlace(clickedStack)) continue;
                paybackSlot.set(clickedStack.copy());
                paybackSlot.setChanged();
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean clickMenuButton(@NotNull Player player, int buttonId) {
        if (buttonId == 0) {
            PaybackTagContents contents = PaybackTagContents.create((Container)this.paybackContainer);
            if (contents.isEmpty()) {
                this.getTag().remove(Envelope.DataComponents.PAYBACK_TAG_CONTENTS);
            } else {
                this.getTag().set(Envelope.DataComponents.PAYBACK_TAG_CONTENTS, contents);
            }
            player.level().playSound(player, (Entity)player, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, player.level().getRandom().nextFloat() * 0.3f + 0.85f);
            player.setItemInHand(this.getHand(), this.getTag().getItemStack());
            return true;
        }
        if (buttonId >= 100) {
            int change;
            int id = buttonId - 100;
            int slotIndex = id % 6;
            boolean decrease = id >= 12;
            boolean fast = id % 12 >= 6;
            int n = change = fast ? 5 : 1;
            if (decrease) {
                change *= -1;
            }
            ItemStack stack = this.paybackContainer.getItem(slotIndex);
            stack.setCount(Mth.clamp((int)(stack.getCount() + change), (int)1, (int)stack.getMaxStackSize()));
            this.paybackContainer.setChanged();
        }
        return false;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId < 0 || slotId >= 6) {
            super.clicked(slotId, button, clickType, player);
            return;
        }
        Slot paybackSlot = (Slot)this.slots.get(slotId);
        if (!this.getCarried().isEmpty() && paybackSlot.mayPlace(this.getCarried())) {
            ItemStack result = this.getCarried().copy();
            if (button == 1) {
                if (ItemStack.isSameItemSameComponents((ItemStack)paybackSlot.getItem(), (ItemStack)result)) {
                    result.setCount(paybackSlot.getItem().getCount() + 1);
                } else {
                    result.setCount(1);
                }
            }
            paybackSlot.set(result);
        } else {
            paybackSlot.set(ItemStack.EMPTY);
        }
    }

    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).getItem() instanceof PaybackTagItem;
    }
}

