/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryUtil {
    public static boolean canAddWholeStack(Player player, ItemStack stack) {
        Inventory inventory = player.getInventory();
        ItemStack insertedStack = stack.copy();
        for (int i = 0; i < inventory.items.size(); ++i) {
            int space;
            ItemStack slotStack = inventory.getItem(i);
            if (slotStack.isEmpty()) {
                int maxInsert = Math.min(inventory.getMaxStackSize(), insertedStack.getMaxStackSize());
                insertedAmount = Math.min(insertedStack.getCount(), maxInsert);
                insertedStack.shrink(insertedAmount);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)insertedStack) && (space = Math.min(inventory.getMaxStackSize(), slotStack.getMaxStackSize()) - slotStack.getCount()) > 0) {
                insertedAmount = Math.min(space, insertedStack.getCount());
                insertedStack.shrink(insertedAmount);
            }
            if (!insertedStack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean tryAddWholeStack(Player player, ItemStack stack) {
        Inventory inventory = player.getInventory();
        ItemStack insertedStack = stack.copy();
        for (int i = 0; i < inventory.items.size(); ++i) {
            int space;
            ItemStack slotStack = inventory.getItem(i);
            if (slotStack.isEmpty()) {
                int maxInsert = Math.min(inventory.getMaxStackSize(), insertedStack.getMaxStackSize());
                insertedAmount = Math.min(insertedStack.getCount(), maxInsert);
                insertedStack.shrink(insertedAmount);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)insertedStack) && (space = Math.min(inventory.getMaxStackSize(), slotStack.getMaxStackSize()) - slotStack.getCount()) > 0) {
                insertedAmount = Math.min(space, insertedStack.getCount());
                insertedStack.shrink(insertedAmount);
            }
            if (!insertedStack.isEmpty()) continue;
            player.getInventory().add(stack);
            return true;
        }
        return false;
    }
}

