/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record RequestedItem(Either<TagKey<Item>, Holder<Item>> item, int count, DataComponentPredicate components) {
    public static final Codec<RequestedItem> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.xor((Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM), (Codec)ItemStack.ITEM_NON_AIR_CODEC).fieldOf("item").forGetter(RequestedItem::item), (App)ExtraCodecs.intRange((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(RequestedItem::count), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(RequestedItem::components)).apply((Applicative)i, RequestedItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestedItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ResourceLocation.STREAM_CODEC.map(id -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id), TagKey::location), (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM)), RequestedItem::item, (StreamCodec)ByteBufCodecs.INT, RequestedItem::count, (StreamCodec)DataComponentPredicate.STREAM_CODEC, RequestedItem::components, RequestedItem::new);
    public static final RequestedItem DEFAULT = new RequestedItem((ItemLike)Items.EMERALD);

    public RequestedItem {
        Preconditions.checkArgument((count >= 1 && count <= 99 ? 1 : 0) != 0, (Object)"Count must be in range 1-99.");
    }

    public RequestedItem(TagKey<Item> tag, int count, DataComponentPredicate components) {
        this((Either<TagKey<Item>, Holder<Item>>)Either.left(tag), count, components);
    }

    public RequestedItem(TagKey<Item> tag, int count) {
        this(tag, count, DataComponentPredicate.EMPTY);
    }

    public RequestedItem(TagKey<Item> tag) {
        this(tag, 1);
    }

    public RequestedItem(ItemLike item, int count, DataComponentPredicate components) {
        this((Either<TagKey<Item>, Holder<Item>>)Either.right((Object)item.asItem().builtInRegistryHolder()), count, components);
    }

    public RequestedItem(ItemLike item, int count) {
        this(item, count, DataComponentPredicate.EMPTY);
    }

    public RequestedItem(ItemLike item) {
        this(item, 1);
    }

    public List<Item> items() {
        return (List)this.item().map(tag -> BuiltInRegistries.ITEM.getTag(tag).map(named -> named.stream().map(Holder::value).toList()).orElse(List.of(Items.BARRIER)), itemHolder -> List.of((Item)itemHolder.value()));
    }

    public boolean matches(ItemStack stack) {
        return this.typeMatches(stack) && this.countEquals(stack) && this.componentsMatch(stack);
    }

    public boolean typeMatches(ItemStack stack) {
        return (Boolean)this.item.map(arg_0 -> ((ItemStack)stack).is(arg_0), arg_0 -> ((ItemStack)stack).is(arg_0));
    }

    public boolean countMatches(ItemStack stack) {
        return stack.getCount() >= Math.min(this.count(), stack.getMaxStackSize());
    }

    public boolean countEquals(ItemStack stack) {
        return stack.getCount() == Math.min(this.count(), stack.getMaxStackSize());
    }

    public boolean componentsMatch(ItemStack stack) {
        return this.components().test((DataComponentHolder)stack);
    }
}

