/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory.slot;

import io.github.mortuusars.envelope.world.inventory.RequestedItem;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RequestedItemSlot
extends Slot {
    private final RequestedItem requestedItem;
    private ItemStack preview = ItemStack.EMPTY;
    private long previewLastChange = 0L;
    private int previewTagIndex = 0;

    public RequestedItemSlot(Container container, int slot, int x, int y, RequestedItem requestedItem) {
        super(container, slot, x, y);
        this.requestedItem = requestedItem;
    }

    public RequestedItem getRequestedItem() {
        return this.requestedItem;
    }

    public ItemStack getRequestedItemPreview() {
        if (Util.getMillis() - this.previewLastChange > 1500L) {
            Item item = (Item)this.getRequestedItem().item().map(tag -> {
                List<Item> items = BuiltInRegistries.ITEM.getTag(tag).map(named -> named.stream().map(Holder::value).toList()).orElse(List.of(Items.BARRIER));
                if (items.isEmpty()) {
                    items = List.of(Items.BARRIER);
                }
                if (this.previewTagIndex >= items.size()) {
                    this.previewTagIndex = 0;
                }
                return items.get(this.previewTagIndex++);
            }, Holder::value);
            this.previewLastChange = Util.getMillis();
            this.preview = new ItemStack((ItemLike)item, this.requestedItem.count());
            this.preview.applyComponents(this.requestedItem.components().asPatch());
        }
        return this.preview;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.requestedItem.typeMatches(stack) && this.requestedItem.componentsMatch(stack);
    }

    public int getMaxStackSize() {
        return this.requestedItem.count();
    }
}

