/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.OpenAddressTagScreenS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.item.ApplicatorItem;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressTagItem
extends Item
implements ApplicatorItem {
    public AddressTagItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        @Nullable Address address = (Address)stack.get(Envelope.DataComponents.ADDRESS);
        if (address != null) {
            tooltipComponents.add((Component)address.format().withIcon().withIconColor(-1651816).withColor(-1651816).toComponent());
        }
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        Address recipient;
        ItemStack target = slot.getItem();
        if (action != ClickAction.SECONDARY || !slot.allowModification(player) || !target.is(Envelope.Tags.Items.MAILABLE)) {
            return false;
        }
        @Nullable Address address = (Address)stack.get(Envelope.DataComponents.ADDRESS);
        if (Objects.equals(address, recipient = (Address)Mail.getRecipient(target).orElse(null))) {
            return true;
        }
        ItemStack result = target.copy();
        Mail.setRecipient(result, address);
        Mail.removePreviousDeliveryData(result);
        if (!slot.mayPlace(result)) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 1.0f);
            return true;
        }
        slot.setByPlayer(result);
        if (address != null) {
            stack.shrink(1);
        }
        player.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 1.0f, 1.0f);
        return true;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() instanceof MailboxBlock) {
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AllAddresses knownAddresses = MailService.of(serverPlayer.serverLevel()).getKnownAddresses();
            Packets.sendToClient(new OpenAddressTagScreenS2CP(usedHand, knownAddresses), serverPlayer);
            player.getCooldowns().addCooldown((Item)this, 6);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide);
    }

    @Override
    public boolean shouldRenderTooltipWhileCarrying(Level level, ItemStack carried, ItemStack hovered) {
        return true;
    }
}

