/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.OpenMailboxPlacingScreenS2CP;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class MailboxBlockItem
extends BlockItem {
    public MailboxBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (!MailService.operatesIn(context.getLevel()) || ((CustomData)context.getItemInHand().getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).contains("address")) {
            return super.useOn(context);
        }
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
        if (blockPlaceContext.canPlace()) {
            Player player = blockPlaceContext.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockHitResult hitResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
                OpenMailboxPlacingScreenS2CP packet = new OpenMailboxPlacingScreenS2CP(context.getHand(), hitResult, MailService.of(serverPlayer.serverLevel()).getKnownAddresses());
                Packets.sendToClient(packet, serverPlayer);
            }
            context.getLevel().playSound(context.getPlayer(), context.getClickedPos(), this.getInitialSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected SoundEvent getInitialSound() {
        return SoundEvents.WOOD_PLACE;
    }
}

