/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.PackingBox;
import io.github.mortuusars.envelope.world.item.PackingBoxItem;
import io.github.mortuusars.envelope.world.item.Sealable;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageItem
extends BlockItem
implements PackingBox,
Sealable {
    public PackageItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((TooltipComponent)stack.get(Envelope.DataComponents.PACKAGE_CONTENTS));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (this.shouldBeDestroyedWhenEmpty(stack)) {
            components.add((Component)Component.literal((String)"\u26a0").withColor(-1801868));
        }
        @Nullable SeededContainerLoot loot = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT);
        if (tooltipFlag.isAdvanced() && loot != null) {
            components.add((Component)Component.literal((String)"Loot Table: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)loot.lootTable().location().toString()).withStyle(ChatFormatting.DARK_GRAY)));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return (Boolean)Config.Server.PACKAGE_LAST_OPEN_ANIMATION.get() != false && this.shouldBeDestroyedWhenEmpty(stack) ? 15 : 0;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        return Envelope.SoundEvents.PAPER_TEAR.get();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (!context.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (((Boolean)Config.Server.PACKAGE_LAST_OPEN_ANIMATION.get()).booleanValue() && this.shouldBeDestroyedWhenEmpty(stack)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.success((Object)this.open(level, player, hand, stack));
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.open(level, player, player.getUsedItemHand(), stack);
        }
        return super.finishUsingItem(stack, level, entity);
    }

    protected ItemStack open(Level level, Player player, InteractionHand hand, ItemStack stack) {
        stack = stack.transmuteCopy((ItemLike)Envelope.Items.PACKING_BOX.get());
        Mail.removePreviousDeliveryData(stack);
        this.unpackLootTableIfPresent(stack, level, player.blockPosition(), player);
        level.playSound(player, (Entity)player, Envelope.SoundEvents.PAPER_TEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Item item = stack.getItem();
        if (item instanceof PackingBoxItem) {
            PackingBoxItem packingBox = (PackingBoxItem)item;
            packingBox.openPackingGui(player, hand, stack);
        } else {
            Envelope.LOGGER.error("Cannot open packing box gui. Stack {} is not a PackingBoxItem.", (Object)stack.getHoverName().getString());
        }
        return stack;
    }

    protected void unpackLootTableIfPresent(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        @Nullable SeededContainerLoot loot = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (loot != null) {
                ResourceKey table = loot.lootTable();
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(table);
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos));
                if (player != null) {
                    builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
                }
                SimpleContainer container = new SimpleContainer(6);
                lootTable.fill((Container)container, builder.create(LootContextParamSets.CHEST), loot.seed());
                if (stack.has(Envelope.DataComponents.PACKAGE_CONTENTS)) {
                    Envelope.LOGGER.warn("Unpacking container loot into the Package, that already has contents inside. Loot will override the contents.");
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.GENERATE_LOOT.trigger(serverPlayer, table);
                }
                stack.remove(DataComponents.CONTAINER_LOOT);
                stack.set(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)PackageContents.createFrom((Container)container));
            }
        }
    }

    public List<ItemStack> unpack(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        this.unpackLootTableIfPresent(stack, level, pos, player);
        PackageContents contents = (PackageContents)stack.getOrDefault(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)PackageContents.EMPTY);
        stack.remove(Envelope.DataComponents.PACKAGE_CONTENTS);
        return contents.copyItems();
    }

    @Override
    public ItemStack seal(Level level, ItemStack stack, Seal seal) {
        ItemStack sealedLetter = stack.transmuteCopy((ItemLike)Envelope.Items.SEALED_PACKAGE.get());
        sealedLetter.set(Envelope.DataComponents.SEAL, (Object)seal);
        return sealedLetter;
    }
}

