/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import net.minecraft.world.item.ItemStack;

public interface PackingBox {
    default public int getTimesPacked(ItemStack stack) {
        return (Integer)stack.getOrDefault(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)0);
    }

    default public int getRemainingPacks(ItemStack stack) {
        return (Integer)Config.Server.PACKAGE_PACK_LIMIT.get() - this.getTimesPacked(stack);
    }

    default public boolean canPack(ItemStack stack) {
        return this.getTimesPacked(stack) < (Integer)Config.Server.PACKAGE_PACK_LIMIT.get();
    }

    default public boolean shouldBeDestroyedWhenEmpty(ItemStack stack) {
        return !this.canPack(stack);
    }

    default public boolean canInsert(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems() && !stack.is(Envelope.Tags.Items.CANNOT_BE_PACKAGED);
    }
}

