/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.GameTime;
import io.github.mortuusars.envelope.world.item.PaybackPackingBoxItem;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaybackPackageItem
extends Item {
    public PaybackPackageItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((TooltipComponent)stack.get(Envelope.DataComponents.PACKAGE_CONTENTS));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        @Nullable PaybackSubject subject = (PaybackSubject)stack.get(Envelope.DataComponents.PAYBACK_SUBJECT);
        if (subject != null && !subject.mail().isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)"\u231b ").append((Component)GameTime.formatLargest(subject.timeoutTick() - Minecrft.level().getGameTime(), false)).withStyle(DeliveryRecord.MessageType.NEGATIVE.getStyle()));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        stack = stack.transmuteCopy((ItemLike)Envelope.Items.PAYBACK_PACKING_BOX.get());
        player.setItemInHand(hand, stack);
        ((PaybackPackingBoxItem)stack.getItem()).openPackingGui(player, hand, stack);
        return InteractionResultHolder.success((Object)stack);
    }
}

