/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.GameTime;
import io.github.mortuusars.envelope.world.inventory.PaybackPackingMenu;
import io.github.mortuusars.envelope.world.item.PackingBox;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaybackPackingBoxItem
extends Item
implements PackingBox {
    public PaybackPackingBoxItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        @Nullable PaybackSubject subject = (PaybackSubject)stack.get(Envelope.DataComponents.PAYBACK_SUBJECT);
        if (subject != null && !subject.mail().isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)"\u231b ").append((Component)GameTime.formatLargest(subject.timeoutTick() - Minecrft.level().getGameTime(), false)).withStyle(DeliveryRecord.MessageType.NEGATIVE.getStyle()));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.openPackingGui(player, hand, stack)) {
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public boolean openPackingGui(Player player, InteractionHand hand, ItemStack stack) {
        @Nullable PaybackSubject subject = (PaybackSubject)stack.get(Envelope.DataComponents.PAYBACK_SUBJECT);
        if (subject == null || subject.mail().isEmpty() || !subject.mail().has(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlatformHelper.openMenu(serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, pl) -> new PaybackPackingMenu(id, inventory, hand), stack.getHoverName()), buffer -> buffer.writeEnum((Enum)hand));
        }
        player.level().playSound(player, (Entity)player, Envelope.SoundEvents.PAPER_USE.get(), SoundSource.PLAYERS, 0.6f, 0.95f);
        return true;
    }
}

