/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent;
import io.github.mortuusars.envelope.world.item.ApplicatorItem;
import io.github.mortuusars.envelope.world.item.Sealable;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.component.seal.SealImpression;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SealStampItem
extends Item
implements ApplicatorItem {
    public SealStampItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            ResourceLocation texture = ((SealImpression)this.getImpressionOrDefault(stack, Minecrft.registryAccess(), null).value()).textureId();
            tooltipComponents.add((Component)Component.literal((String)"Impression:").withStyle(ChatFormatting.DARK_GRAY).append(CommonComponents.SPACE).append((Component)Component.literal((String)texture.toString()).withStyle(ChatFormatting.GRAY)));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new SealDieTooltipComponent(Optional.ofNullable((Holder)stack.get(Envelope.DataComponents.SEAL_STAMP_IMPRESSION))));
    }

    @Override
    public boolean shouldRenderTooltipWhileCarrying(Level level, ItemStack carried, ItemStack hovered) {
        Sealable sealable;
        Item item;
        return hovered.has(Envelope.DataComponents.SEAL) || (item = hovered.getItem()) instanceof Sealable && (sealable = (Sealable)item).canSeal(level, hovered);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        Sealable sealable;
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (!slot.allowModification(player)) {
            player.playSound(SoundEvents.COMPARATOR_CLICK);
            return true;
        }
        ItemStack target = slot.getItem();
        @Nullable Seal existingSeal = (Seal)target.get(Envelope.DataComponents.SEAL);
        if (existingSeal != null && this.canApplyGold(stack, player)) {
            ResourceKey<SealMaterial> currentMaterial = existingSeal.material().unwrapKey().orElse(SealMaterial.RED_WAX);
            ResourceKey<SealMaterial> newMaterial = currentMaterial == SealMaterial.RED_WAX ? SealMaterial.GOLD : SealMaterial.RED_WAX;
            Holder<SealMaterial> material = SealMaterial.getHolder(player.registryAccess(), newMaterial);
            target.set(Envelope.DataComponents.SEAL, (Object)new Seal(material, existingSeal.impression(), existingSeal.signature()));
            slot.set(target);
            player.playSound(SoundEvents.UI_LOOM_SELECT_PATTERN);
            return true;
        }
        Item newMaterial = target.getItem();
        if (!(newMaterial instanceof Sealable) || !(sealable = (Sealable)newMaterial).canSeal(player.level(), target)) {
            player.playSound(SoundEvents.COMPARATOR_CLICK);
            return true;
        }
        ItemStack sealResult = sealable.seal(player.level(), target, this.createSeal(stack, player));
        slot.set(sealResult);
        player.playSound(SoundEvents.UI_LOOM_SELECT_PATTERN);
        return true;
    }

    public Seal createSeal(ItemStack stack, Player player) {
        return new Seal(SealMaterial.getHolder(player.registryAccess(), SealMaterial.RED_WAX), this.getImpressionOrDefault(stack, player.registryAccess(), player), player.getName());
    }

    public Optional<Holder<SealImpression>> getImpression(ItemStack stack) {
        return Optional.ofNullable((Holder)stack.get(Envelope.DataComponents.SEAL_STAMP_IMPRESSION));
    }

    public Holder<SealImpression> getImpressionOrDefault(ItemStack stack, RegistryAccess registryAccess, @Nullable Player player) {
        return this.getImpression(stack).orElseGet(() -> SealImpression.getHolder(registryAccess, SealImpression.firstCharOrDefault(player)));
    }

    protected boolean canApplyGold(ItemStack stack, Player player) {
        return false;
    }
}

