/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.PackageBlockEntity;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface Sealable {
    public ItemStack seal(Level var1, ItemStack var2, Seal var3);

    default public boolean canSeal(Level level, ItemStack stack) {
        return !stack.has(Envelope.DataComponents.SEAL);
    }

    public static int getSealOverlayColor(ItemStack stack, int layer) {
        if (layer != 1) {
            return -1;
        }
        @Nullable Seal seal = (Seal)stack.get(Envelope.DataComponents.SEAL);
        if (seal != null) {
            return ((SealMaterial)seal.material().value()).modelTintColor();
        }
        return -3387833;
    }

    public static int getSealOverlayColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        PackageBlockEntity blockEntity;
        Seal seal;
        BlockEntity blockEntity2;
        if (index != 0) {
            return -1;
        }
        if (level != null && pos != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof PackageBlockEntity && (seal = (Seal)(blockEntity = (PackageBlockEntity)blockEntity2).getPackage().get(Envelope.DataComponents.SEAL)) != null) {
            return ((SealMaterial)seal.material().value()).modelTintColor();
        }
        return -3387833;
    }
}

