/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.Unsealable;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SealedLetterItem
extends Item
implements Unsealable {
    public SealedLetterItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ItemLike getUnsealedItem() {
        return (ItemLike)Envelope.Items.LETTER.get();
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((TooltipComponent)stack.get(Envelope.DataComponents.SEAL));
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        return this.getUnsealingSound();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getUnsealingDuration(stack, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        return this.unseal(stack, level, entity);
    }
}

