/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.PackageItem;
import io.github.mortuusars.envelope.world.item.Unsealable;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SealedPackageItem
extends PackageItem
implements Unsealable {
    public SealedPackageItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public ItemLike getUnsealedItem() {
        return (ItemLike)Envelope.Items.PACKAGE.get();
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((TooltipComponent)stack.get(Envelope.DataComponents.SEAL));
    }

    @Override
    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    @Override
    @NotNull
    public SoundEvent getEatingSound() {
        return this.getUnsealingSound();
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getUnsealingDuration(stack, entity);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Override
    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        return this.unseal(stack, level, entity);
    }
}

