/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.util.Minecrft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface Unsealable {
    public ItemLike getUnsealedItem();

    default public SoundEvent getUnsealingSound() {
        return Envelope.SoundEvents.PAPER_CRACKLE.get();
    }

    default public SoundEvent getUnsealFinishedSound() {
        return Envelope.SoundEvents.PAPER_TEAR.get();
    }

    default public int getUnsealingDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    default public ItemStack unseal(ItemStack stack, Level level, @Nullable LivingEntity entity) {
        ItemStack unsealedStack = stack.transmuteCopy(this.getUnsealedItem());
        unsealedStack.remove(Envelope.DataComponents.SEAL);
        this.onUnsealed(stack, unsealedStack, level, entity);
        return unsealedStack;
    }

    default public void onUnsealed(ItemStack stack, ItemStack unsealedStack, Level level, @Nullable LivingEntity entity) {
        if (entity != null) {
            Player pl;
            Player player = entity instanceof Player ? (pl = (Player)entity) : null;
            level.playSound(player, (Entity)entity, this.getUnsealFinishedSound(), SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.8f);
        }
        if (level.isClientSide()) {
            Minecrft.releaseUseButton();
        }
    }
}

