/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.mortuusars.envelope.world.GameTime;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class Id
implements GameTime,
Comparable<Id> {
    public static final Codec<Id> CODEC = Codec.STRING.comapFlatMap(Id::parse, Id::toString);
    public static final StreamCodec<ByteBuf, Id> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, Id::getTick, (StreamCodec)ByteBufCodecs.VAR_INT, Id::getSuffix, Id::new);
    private final long tick;
    private final int suffix;
    private static volatile long currentTick;
    private static final AtomicInteger currentSuffix;

    private Id(long tick, int suffix) {
        Preconditions.checkArgument((tick >= 0L ? 1 : 0) != 0, (Object)("Tick must be >= 0. Value: " + tick));
        Preconditions.checkArgument((suffix >= 0 ? 1 : 0) != 0, (Object)("Suffix must be >= 0. Value: " + suffix));
        this.tick = tick;
        this.suffix = suffix;
    }

    @Override
    public long get() {
        return this.getTick();
    }

    public long getTick() {
        return this.tick;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.suffix <= 0 ? Long.toString(this.tick) : this.tick + "-" + this.suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.tick == id.tick && this.suffix == id.suffix;
    }

    public int hashCode() {
        return Objects.hash(this.tick, this.suffix);
    }

    @Override
    public int compareTo(@NotNull Id other) {
        Preconditions.checkNotNull((Object)other);
        if (this.equals(other)) {
            return 0;
        }
        if (this.tick == other.tick) {
            return Integer.compare(this.suffix, other.suffix);
        }
        return Long.compare(this.tick, other.tick);
    }

    public static Id create(long tick) {
        if (tick < currentTick) {
            throw new IllegalArgumentException("Cannot generate Id for non-current tick: " + tick + ". Current tick: " + currentTick);
        }
        if (tick != currentTick) {
            currentTick = tick;
            currentSuffix.set(0);
        }
        return new Id(tick, currentSuffix.getAndIncrement());
    }

    public static Id create(GameTime time) {
        return Id.create(time.get());
    }

    public static Id create(Level level) {
        return Id.create(level.getGameTime());
    }

    public static Id createUnsafe(long tick, int suffix) {
        return new Id(tick, suffix);
    }

    public static Id createUnsafe(long tick) {
        return Id.createUnsafe(tick, 0);
    }

    public static Id createUnsafe(GameTime time) {
        return Id.createUnsafe(time.get());
    }

    public static DataResult<Id> parse(String input) {
        if (input == null || input.isBlank()) {
            return DataResult.error(() -> "Id string is null or empty");
        }
        String[] parts = input.split("-", -1);
        if (parts.length > 2) {
            return DataResult.error(() -> "Invalid Id format: " + input);
        }
        try {
            long tick = Long.parseLong(parts[0]);
            if (tick < 0L) {
                return DataResult.error(() -> "Tick must be larger or equal to 0. Input: " + input);
            }
            int suffix = 0;
            if (parts.length == 2) {
                if (parts[1].isEmpty()) {
                    return DataResult.error(() -> "Suffix is empty in Id: " + input);
                }
                suffix = Integer.parseInt(parts[1]);
                if (suffix < 0) {
                    return DataResult.error(() -> "Suffix must be larger or equal to 0. Input: " + input);
                }
            }
            return DataResult.success((Object)new Id(tick, suffix));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid number in Id: " + input);
        }
    }

    static {
        currentSuffix = new AtomicInteger();
    }
}

