/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public final class PackageContents
implements TooltipComponent {
    public static final int SLOTS = 6;
    public static final Codec<PackageContents> CODEC = ItemStack.OPTIONAL_CODEC.listOf(0, 6).xmap(PackageContents::new, PackageContents::getItemsForSerialization);
    public static final StreamCodec<RegistryFriendlyByteBuf, PackageContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)6)).map(PackageContents::new, PackageContents::getItemsForReading);
    public static final PackageContents EMPTY = new PackageContents(Collections.emptyList());
    private final List<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);

    public PackageContents(List<ItemStack> items) {
        for (int i = 0; i < Math.min(items.size(), 6); ++i) {
            this.items.set(i, items.get(i));
        }
    }

    public static PackageContents createFrom(Container container) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < Math.min(container.getContainerSize(), 6); ++i) {
            items.add(container.getItem(i));
        }
        return new PackageContents(items);
    }

    public static PackageContents from(ItemStack stack) {
        return (PackageContents)stack.getOrDefault(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)EMPTY);
    }

    public int size() {
        return this.items.size();
    }

    public List<ItemStack> getItemsForReading() {
        return this.items;
    }

    private List<ItemStack> getItemsForSerialization() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        for (int i = list.size() - 1; i >= 0 && ((ItemStack)list.get(i)).isEmpty(); --i) {
            list.remove(i);
        }
        return list;
    }

    public ItemStack getItemForReading(int index) {
        return index < this.size() ? this.items.get(index) : ItemStack.EMPTY;
    }

    public List<ItemStack> copyItems() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object another) {
        if (this == another) return true;
        if (!(another instanceof PackageContents)) return false;
        PackageContents packageContents = (PackageContents)another;
        if (!ItemStack.listMatches(this.items, packageContents.items)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "PackageContents" + String.valueOf(this.items);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.getItemsForReading().isEmpty() || this.getItemsForReading().stream().allMatch(ItemStack::isEmpty);
    }
}

