/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component;

import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.world.inventory.ContainerUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record PaybackTagContents(List<ItemStack> items) implements TooltipComponent
{
    public static final int SLOTS = 6;
    public static final Codec<PaybackTagContents> CODEC = ItemStack.OPTIONAL_CODEC.listOf(0, 6).xmap(PaybackTagContents::new, PaybackTagContents::getItemsForReading);
    public static final StreamCodec<RegistryFriendlyByteBuf, PaybackTagContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)6)).map(PaybackTagContents::new, PaybackTagContents::getItemsForReading);
    public static final PaybackTagContents EMPTY = new PaybackTagContents(Collections.emptyList());
    public static final PaybackTagContents DEFAULT = new PaybackTagContents(List.of(new ItemStack((ItemLike)Items.EMERALD)));

    public static PaybackTagContents create(Container container) {
        Container compactedContainer = ContainerUtils.compact(container, 6);
        List<ItemStack> items = ContainerUtils.toList(compactedContainer, 6).stream().filter(i -> !i.isEmpty()).toList();
        return new PaybackTagContents(items);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.items.isEmpty() || this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public List<ItemStack> getItemsForReading() {
        return this.items;
    }

    public ItemStack getItemForReading(int index) {
        return index < this.size() ? this.items.get(index) : ItemStack.EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object another) {
        if (this == another) return true;
        if (!(another instanceof PaybackTagContents)) return false;
        PaybackTagContents contents = (PaybackTagContents)another;
        if (!ItemStack.listMatches(this.items, contents.items)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }
}

