/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.inventory.RequestedItem;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public record RequestedPayback(List<RequestedItem> items) implements TooltipComponent
{
    public static final int SLOTS = 6;
    public static final RequestedPayback DEFAULT = new RequestedPayback(List.of(RequestedItem.DEFAULT));
    public static final Codec<RequestedPayback> CODEC = Codec.list(RequestedItem.CODEC, (int)1, (int)6).xmap(RequestedPayback::new, RequestedPayback::items);
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestedPayback> STREAM_CODEC = RequestedItem.STREAM_CODEC.apply(ByteBufCodecs.list((int)6)).map(RequestedPayback::new, RequestedPayback::items);

    public RequestedPayback {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"Payback must have at least one requested item.");
    }

    public static Optional<RequestedPayback> create(List<RequestedItem> items) {
        return !items.isEmpty() ? Optional.of(new RequestedPayback(items)) : Optional.empty();
    }

    public static RequestedPayback createOrDefault(List<RequestedItem> items) {
        return !items.isEmpty() ? new RequestedPayback(items) : DEFAULT;
    }

    public boolean matches(Container container) {
        for (int slot = 0; slot < this.items().size(); ++slot) {
            RequestedItem requestedItem = this.items().get(slot);
            if (slot >= container.getContainerSize()) {
                return false;
            }
            ItemStack stack = container.getItem(slot);
            if (requestedItem.matches(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(PackageContents packageContents) {
        for (int slot = 0; slot < this.items().size(); ++slot) {
            RequestedItem requestedItem = this.items().get(slot);
            if (slot >= packageContents.size()) {
                return false;
            }
            ItemStack stack = packageContents.getItemForReading(slot);
            if (requestedItem.matches(stack)) continue;
            return false;
        }
        return true;
    }

    public Optional<RequestedItem> getRequestedItem(int index) {
        return index < this.items.size() ? Optional.of(this.items.get(index)) : Optional.empty();
    }

    public static boolean isValidPaybackItem(ItemStack stack) {
        return Envelope.Items.PACKING_BOX.get().canInsert(stack) && !stack.is(Envelope.Tags.Items.CANNOT_BE_USED_AS_PAYBACK);
    }
}

