/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.mail.log;

import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record DeliveryLog(List<DeliveryRecord> records) {
    public static final Codec<DeliveryLog> CODEC = DeliveryRecord.CODEC.listOf(0, 64).xmap(DeliveryLog::new, DeliveryLog::records);
    public static final StreamCodec<RegistryFriendlyByteBuf, DeliveryLog> STREAM_CODEC = DeliveryRecord.STREAM_CODEC.apply(ByteBufCodecs.list((int)64)).map(DeliveryLog::new, DeliveryLog::records);
    public static final DeliveryLog EMPTY = new DeliveryLog(Collections.emptyList());

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public DeliveryLog append(DeliveryRecord record) {
        ArrayList<DeliveryRecord> records = new ArrayList<DeliveryRecord>(this.records);
        records.add(record);
        return new DeliveryLog(records);
    }

    public DeliveryLog append(DeliveryRecord.Builder recordBuilder) {
        return this.append(recordBuilder.build());
    }

    public DeliveryLog append(DeliveryRecord ... list) {
        ArrayList<DeliveryRecord> records = new ArrayList<DeliveryRecord>(this.records);
        records.addAll(Arrays.asList(list));
        return new DeliveryLog(records);
    }

    public DeliveryLog append(DeliveryRecord.Builder ... list) {
        ArrayList<DeliveryRecord> records = new ArrayList<DeliveryRecord>(this.records);
        for (DeliveryRecord.Builder record : list) {
            records.add(record.build());
        }
        return new DeliveryLog(records);
    }
}

