/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.mail.log;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.GameTime;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public record DeliveryRecord(Type type, Optional<Address> address, Optional<Long> timestamp, Optional<Component> message, MessageType messageType) {
    public static final Codec<DeliveryRecord> CODEC = RecordCodecBuilder.create(i -> i.group((App)Type.CODEC.fieldOf("type").forGetter(DeliveryRecord::type), (App)Address.CODEC.optionalFieldOf("address").forGetter(DeliveryRecord::address), (App)Codec.LONG.optionalFieldOf("timestamp").forGetter(DeliveryRecord::timestamp), (App)ComponentSerialization.CODEC.optionalFieldOf("message").forGetter(DeliveryRecord::message), (App)MessageType.CODEC.optionalFieldOf("message_type", (Object)MessageType.NEUTRAL).forGetter(DeliveryRecord::messageType)).apply((Applicative)i, DeliveryRecord::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DeliveryRecord> STREAM_CODEC = StreamCodec.composite(Type.STREAM_CODEC, DeliveryRecord::type, (StreamCodec)ByteBufCodecs.optional(Address.STREAM_CODEC), DeliveryRecord::address, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_LONG), DeliveryRecord::timestamp, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ComponentSerialization.STREAM_CODEC), DeliveryRecord::message, MessageType.STREAM_CODEC, DeliveryRecord::messageType, DeliveryRecord::new);

    public static DeliveryRecord sentFrom(@NotNull Address address, long timestamp) {
        Preconditions.checkNotNull((Object)address);
        return new DeliveryRecord(Type.SENT, Optional.of(address), Optional.of(timestamp), Optional.empty(), MessageType.NEUTRAL);
    }

    public static DeliveryRecord arrivedTo(@NotNull Address address, long timestamp) {
        Preconditions.checkNotNull((Object)address);
        return new DeliveryRecord(Type.ARRIVED, Optional.of(address), Optional.of(timestamp), Optional.empty(), MessageType.NEUTRAL);
    }

    public static DeliveryRecord returned(Component reason) {
        Preconditions.checkNotNull((Object)reason);
        return new DeliveryRecord(Type.RETURNED, Optional.of(Address.MAIL_SERVICE), Optional.empty(), Optional.of(reason), MessageType.NEGATIVE);
    }

    public static DeliveryRecord payback(@NotNull Component message, MessageType type) {
        return new DeliveryRecord(Type.PAYBACK, Optional.empty(), Optional.empty(), Optional.of(message), type);
    }

    public MutableComponent toComponent(long gameTime) {
        int addressColor = switch (this.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -8735263;
            case 1 -> -1528457;
            case 2, 3, 4 -> -1651816;
        };
        Component addressComponent = (Component)this.address.map(a -> a.format().withIcon().withIconColor(addressColor).withColor(addressColor).toComponent()).orElse(Component.empty());
        MutableComponent messageComponent = Component.empty().append(this.message.orElse(CommonComponents.EMPTY)).withStyle(this.messageType().getStyle());
        Component elapsedTimeComponent = (Component)this.timestamp.map(time -> GameTime.formatLargest(gameTime - time, false).withStyle(ChatFormatting.DARK_GRAY)).orElse(Component.empty());
        return Component.translatable((String)("gui.envelope.delivery_log.record." + this.type().getSerializedName()), (Object[])new Object[]{addressComponent, messageComponent, elapsedTimeComponent}).withStyle(ChatFormatting.GRAY);
    }

    public static enum Type implements StringRepresentable
    {
        SENT("sent"),
        ARRIVED("arrived"),
        RETURNED("returned"),
        PAYBACK("payback"),
        CUSTOM("custom");

        public static final Codec<Type> CODEC;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public MutableComponent translate() {
            return Component.translatable((String)("gui.envelope.delivery_log.record." + this.getSerializedName()));
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
        }
    }

    public static enum MessageType implements StringRepresentable
    {
        NEUTRAL("neutral", Style.EMPTY.withColor(ChatFormatting.GRAY)),
        POSITIVE("positive", Style.EMPTY.withColor(-9053060)),
        NEGATIVE("negative", Style.EMPTY.withColor(-1801868));

        public static final Codec<MessageType> CODEC;
        public static final StreamCodec<ByteBuf, MessageType> STREAM_CODEC;
        private final String name;
        private final Style style;

        private MessageType(String name, Style style) {
            this.name = name;
            this.style = style;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public Style getStyle() {
            return this.style;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MessageType::values);
            STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])MessageType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
        }
    }

    public static interface Message {
        public static final Component RECIPIENT_NOT_FOUND = Component.translatable((String)"gui.envelope.delivery_log.message.returned_recipient_not_found");
        public static final Component RECIPIENT_INBOX_IS_FULL = Component.translatable((String)"gui.envelope.delivery_log.message.returned_recipient_inbox_is_full");
        public static final Component UNABLE_TO_REACH = Component.translatable((String)"gui.envelope.delivery_log.message.returned_unable_to_reach");
        public static final Component REJECTED = Component.translatable((String)"gui.envelope.delivery_log.message.returned_rejected");
        public static final Component PAYBACK_FULFILLED = Component.translatable((String)"gui.envelope.delivery_log.message.payback_fulfilled");
        public static final Component RETURNED_PAYBACK_SUBJECT_NOT_FOUND = Component.translatable((String)"gui.envelope.delivery_log.message.returned_payback_subject_not_found");
        public static final Component RETURNED_PAYBACK_IS_NOT_VALID = Component.translatable((String)"gui.envelope.delivery_log.message.returned_payback_is_not_valid");
        public static final Component RETURNED_PAYBACK_EXPIRED = Component.translatable((String)"gui.envelope.delivery_log.message.returned_payback_expired");
    }

    public static class Builder {
        private final Type type;
        private Optional<Address> address = Optional.empty();
        private Optional<Long> timestamp = Optional.empty();
        private Optional<Component> message = Optional.empty();
        private MessageType messageType = MessageType.NEUTRAL;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder address(Address address) {
            this.address = Optional.of(address);
            return this;
        }

        public Builder at(long timestamp) {
            this.timestamp = Optional.of(timestamp);
            return this;
        }

        public Builder message(Component message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public DeliveryRecord build() {
            return new DeliveryRecord(this.type, this.address, this.timestamp, this.message, this.messageType);
        }
    }
}

