/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.seal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class SealImpression {
    public static final Codec<SealImpression> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SealImpression::textureId)).apply((Applicative)i, SealImpression::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SealImpression> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SealImpression::textureId, SealImpression::new);
    public static final Codec<Holder<SealImpression>> CODEC = RegistryFileCodec.create(Envelope.Registries.SEAL_IMPRESSION, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SealImpression>> STREAM_CODEC = ByteBufCodecs.holder(Envelope.Registries.SEAL_IMPRESSION, DIRECT_STREAM_CODEC);
    public static final Map<Character, ResourceKey<SealImpression>> LETTERS = (Map)Util.make(new HashMap(), map -> {
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            map.put(Character.valueOf(c), SealImpression.key(String.valueOf(c)));
        }
    });
    public static final Map<Character, ResourceKey<SealImpression>> NUMBERS = (Map)Util.make(new HashMap(), map -> {
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            map.put(Character.valueOf(c), SealImpression.key(String.valueOf(c)));
        }
    });
    public static final Map<String, ResourceKey<SealImpression>> SYMBOLS = new HashMap<String, ResourceKey<SealImpression>>();
    public static final ResourceKey<SealImpression> APPLE = SealImpression.symbolKey("apple");
    public static final ResourceKey<SealImpression> AXE = SealImpression.symbolKey("axe");
    public static final ResourceKey<SealImpression> BLOCK = SealImpression.symbolKey("block");
    public static final ResourceKey<SealImpression> BOOK = SealImpression.symbolKey("book");
    public static final ResourceKey<SealImpression> CREEPER = SealImpression.symbolKey("creeper");
    public static final ResourceKey<SealImpression> EMERALD = SealImpression.symbolKey("emerald");
    public static final ResourceKey<SealImpression> HEART = SealImpression.symbolKey("heart");
    public static final ResourceKey<SealImpression> HOE = SealImpression.symbolKey("hoe");
    public static final ResourceKey<SealImpression> LETTER = SealImpression.symbolKey("letter");
    public static final ResourceKey<SealImpression> PICKAXE = SealImpression.symbolKey("pickaxe");
    public static final ResourceKey<SealImpression> SHOVEL = SealImpression.symbolKey("shovel");
    public static final ResourceKey<SealImpression> SKELETON = SealImpression.symbolKey("skeleton");
    public static final ResourceKey<SealImpression> SKELETON_SMIRK = SealImpression.symbolKey("skeleton_smirk");
    public static final ResourceKey<SealImpression> SWORD = SealImpression.symbolKey("sword");
    public static final ResourceKey<SealImpression> SWORDS = SealImpression.symbolKey("swords");
    public static final ResourceKey<SealImpression> VILLAGER = SealImpression.symbolKey("villager");
    public static final ResourceKey<SealImpression> DEFAULT = CREEPER;
    private final ResourceLocation texture;
    private final ResourceLocation textureFull;

    public SealImpression(ResourceLocation texture) {
        this.texture = texture;
        this.textureFull = texture.withPath(path -> "textures/" + path + ".png");
    }

    public ResourceLocation textureId() {
        return this.texture;
    }

    public ResourceLocation texture() {
        return this.textureFull;
    }

    public static ResourceKey<SealImpression> firstCharOrDefault(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c >= 'a' && c <= 'z') {
                return LETTERS.getOrDefault(Character.valueOf(c), DEFAULT);
            }
            if (c < '0' || c > '9') continue;
            return NUMBERS.getOrDefault(Character.valueOf(c), DEFAULT);
        }
        return DEFAULT;
    }

    public static ResourceKey<SealImpression> firstCharOrDefault(@Nullable Player player) {
        if (player == null) {
            return DEFAULT;
        }
        return SealImpression.firstCharOrDefault(player.getScoreboardName());
    }

    public static Holder<SealImpression> getHolder(RegistryAccess access, ResourceKey<SealImpression> key) {
        return access.registryOrThrow(Envelope.Registries.SEAL_IMPRESSION).getHolderOrThrow(key);
    }

    private static ResourceKey<SealImpression> key(String path) {
        return ResourceKey.create(Envelope.Registries.SEAL_IMPRESSION, (ResourceLocation)Envelope.resource(path));
    }

    private static ResourceKey<SealImpression> symbolKey(String path) {
        ResourceKey key = ResourceKey.create(Envelope.Registries.SEAL_IMPRESSION, (ResourceLocation)Envelope.resource(path));
        SYMBOLS.put(path, (ResourceKey<SealImpression>)key);
        return key;
    }

    public static void bootstrap(BootstrapContext<SealImpression> context) {
        Function<ResourceKey, ResourceLocation> keyToTexture = key -> key.location().withPath(path -> "gui/seal/impression/" + path);
        NUMBERS.values().forEach(key -> context.register(key, (Object)new SealImpression((ResourceLocation)keyToTexture.apply((ResourceKey)key))));
        LETTERS.values().forEach(key -> context.register(key, (Object)new SealImpression((ResourceLocation)keyToTexture.apply((ResourceKey)key))));
        SYMBOLS.values().forEach(key -> context.register(key, (Object)new SealImpression((ResourceLocation)keyToTexture.apply((ResourceKey)key))));
    }
}

