/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.seal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.EnvelopeCodecs;
import io.github.mortuusars.envelope.world.item.component.seal.ShadingPalette;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class SealMaterial {
    public static final Codec<SealMaterial> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SealMaterial::textureId), (App)EnvelopeCodecs.HEX_COLOR.fieldOf("model_tint_color").forGetter(SealMaterial::modelTintColor), (App)ShadingPalette.CODEC.fieldOf("impression_palette").forGetter(SealMaterial::impressionPalette)).apply((Applicative)i, SealMaterial::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SealMaterial> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SealMaterial::textureId, (StreamCodec)ByteBufCodecs.INT, SealMaterial::modelTintColor, ShadingPalette.STREAM_CODEC, SealMaterial::impressionPalette, SealMaterial::new);
    public static final Codec<Holder<SealMaterial>> CODEC = RegistryFileCodec.create(Envelope.Registries.SEAL_MATERIAL, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SealMaterial>> STREAM_CODEC = ByteBufCodecs.holder(Envelope.Registries.SEAL_MATERIAL, DIRECT_STREAM_CODEC);
    public static final ResourceKey<SealMaterial> RED_WAX = ResourceKey.create(Envelope.Registries.SEAL_MATERIAL, (ResourceLocation)Envelope.resource("red_wax"));
    public static final ResourceKey<SealMaterial> GOLD = ResourceKey.create(Envelope.Registries.SEAL_MATERIAL, (ResourceLocation)Envelope.resource("gold"));
    private final ResourceLocation textureId;
    private final ResourceLocation textureFull;
    private final int modelTintColor;
    private final ShadingPalette impressionPalette;

    public SealMaterial(ResourceLocation texture, int modelTintColor, ShadingPalette impressionPalette) {
        this.textureId = texture;
        this.textureFull = texture.withPath(path -> "textures/" + path + ".png");
        this.modelTintColor = modelTintColor;
        this.impressionPalette = impressionPalette;
    }

    public ResourceLocation textureId() {
        return this.textureId;
    }

    public ResourceLocation texture() {
        return this.textureFull;
    }

    public int modelTintColor() {
        return this.modelTintColor;
    }

    public ShadingPalette impressionPalette() {
        return this.impressionPalette;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SealMaterial that = (SealMaterial)obj;
        return Objects.equals(this.textureId, that.textureId) && this.modelTintColor == that.modelTintColor && Objects.equals(this.impressionPalette, that.impressionPalette);
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.textureId.hashCode();
        i = 31 * i + this.modelTintColor;
        return 31 * i + this.impressionPalette.hashCode();
    }

    public String toString() {
        return "SealMaterial[texture=" + String.valueOf(this.textureId) + ", modelTintColor=" + this.modelTintColor + ", impressionPalette=" + String.valueOf(this.impressionPalette) + "]";
    }

    public static Holder<SealMaterial> getHolder(RegistryAccess access, ResourceKey<SealMaterial> key) {
        return access.registryOrThrow(Envelope.Registries.SEAL_MATERIAL).getHolderOrThrow(key);
    }

    public static void bootstrap(BootstrapContext<SealMaterial> context) {
        Function<ResourceKey, ResourceLocation> keyToTexture = key -> key.location().withPath(path -> "gui/seal/material/" + path);
        context.register(RED_WAX, (Object)new SealMaterial(keyToTexture.apply(RED_WAX), -3387833, new ShadingPalette(-5817804, -946568, -10089462, -7723486)));
        context.register(GOLD, (Object)new SealMaterial(keyToTexture.apply(GOLD), -19641, new ShadingPalette(-2648266, -5459, -9096181, -4887260)));
    }
}

