/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.mail;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailBuilder<T extends MailBuilder<T>>
implements DataComponentHolder {
    @NotNull
    private final ItemStack item;

    public MailBuilder(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item);
        this.item = item;
    }

    public MailBuilder(@NotNull Item item) {
        Preconditions.checkNotNull((Object)item);
        this.item = new ItemStack((ItemLike)item);
    }

    T self() {
        return (T)this;
    }

    public T id(Id id) {
        Mail.setId(this.item, id);
        return this.self();
    }

    public T sender(Address sender) {
        Mail.setSender(this.item, sender);
        return this.self();
    }

    public T recipient(Address recipient) {
        Mail.setRecipient(this.item, recipient);
        return this.self();
    }

    public T setLog(DeliveryLog log) {
        Mail.setLog(this.item, log);
        return this.self();
    }

    public T writeToLog(DeliveryRecord record) {
        Mail.writeToLog(this.item, record);
        return this.self();
    }

    public T writeToLog(DeliveryRecord.Builder record) {
        Mail.writeToLog(this.item, record);
        return this.self();
    }

    @NotNull
    public DataComponentMap getComponents() {
        return this.item.getComponents();
    }

    public <V> T set(DataComponentType<V> type, @Nullable V value) {
        this.item.set(type, value);
        return this.self();
    }

    public <V> T update(DataComponentType<V> type, V defaultValue, @NotNull UnaryOperator<V> updater) {
        this.item.update(type, defaultValue, updater);
        return this.self();
    }

    @NotNull
    public ItemStack get() {
        return this.item;
    }
}

