/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public interface Address {
    public static final int MAX_LENGTH = 40;
    public static final Codec<String> ID_CODEC = Codec.STRING.xmap(String::trim, String::trim).validate(Address::validate);
    public static final Codec<Address> CODEC = Type.CODEC.dispatch(Address::type, Type::getCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Address> STREAM_CODEC = Type.STREAM_CODEC.dispatch(Address::type, Type::getStreamCodec);
    public static final Entity MAIL_SERVICE = new Entity("Mail Service", (Component)Component.translatable((String)"address.envelope.mail_service"));
    public static final Address UNKNOWN = new Entity("Unknown", (Component)Component.translatable((String)"address.envelope.unknown"));

    public Type type();

    public String id();

    public String toString();

    default public MutableComponent getName() {
        return Component.literal((String)this.id());
    }

    default public boolean matches(String name) {
        return this.toString().equalsIgnoreCase(name);
    }

    default public boolean matches(Address address) {
        return this.matches(address.toString());
    }

    default public AddressFormatter format() {
        return AddressFormatter.of(this);
    }

    default public <R> R map(Function<Block, R> ifBlock, Function<Player, R> ifPlayer, Function<Entity, R> ifEntity) {
        Address address = this;
        Objects.requireNonNull(address);
        Address address2 = address;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, Player.class, Entity.class}, (Object)address2, n)) {
            case 0 -> {
                Block block = (Block)address2;
                yield ifBlock.apply(block);
            }
            case 1 -> {
                Player player = (Player)address2;
                yield ifPlayer.apply(player);
            }
            case 2 -> {
                Entity entity = (Entity)address2;
                yield ifEntity.apply(entity);
            }
            default -> throw new IllegalStateException("Unknown type of address. " + String.valueOf(this.getClass()));
        };
    }

    @NotNull
    public static DataResult<String> validate(String id) {
        return AddressValidation.id().test(id).map(DataResult::success, Error::asDataResult);
    }

    public record Block(String id) implements Address
    {
        public static final MapCodec<Block> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Block::id)).apply((Applicative)instance, Block::new));
        public static final Codec<Block> STRING_CODEC = Codec.STRING.xmap(Block::new, Block::id);
        public static final StreamCodec<RegistryFriendlyByteBuf, Block> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Block::new, Block::id).cast();

        public Block {
            Address.validate(id).getOrThrow();
        }

        @Override
        public Type type() {
            return Type.BLOCK;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Block that = (Block)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("b" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }

        @Override
        public String toString() {
            return this.id;
        }
    }

    public record Player(String id) implements Address
    {
        public static final MapCodec<Player> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Player::id)).apply((Applicative)instance, Player::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Player> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Player::new, Player::id).cast();

        public Player {
            Address.validate(id).getOrThrow();
        }

        public Player(net.minecraft.world.entity.player.Player player) {
            this(player.getScoreboardName());
        }

        @Override
        public Type type() {
            return Type.PLAYER;
        }

        @Override
        public String toString() {
            return this.id;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Player that = (Player)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("p" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }
    }

    public record Entity(String id, Optional<Component> displayName) implements Address
    {
        public static final MapCodec<Entity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Entity::id), (App)ComponentSerialization.CODEC.optionalFieldOf("display_name").forGetter(Entity::displayName)).apply((Applicative)instance, Entity::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entity> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Entity::id, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ComponentSerialization.STREAM_CODEC), Entity::displayName, Entity::new);

        public Entity {
            Address.validate(id).getOrThrow();
        }

        public Entity(String id, @NotNull Component displayName) {
            this(id, Optional.of(displayName));
        }

        public Entity(String id) {
            this(id, Optional.empty());
        }

        @Override
        public Type type() {
            return Type.ENTITY;
        }

        @Override
        public MutableComponent getName() {
            return this.displayName.map(Component::plainCopy).orElseGet(() -> Address.super.getName());
        }

        @Override
        public String toString() {
            return this.getName().getString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity that = (Entity)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("e" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }
    }

    public static enum Type implements StringRepresentable
    {
        BLOCK(0, "block", Block.CODEC, Block.STREAM_CODEC),
        PLAYER(1, "player", Player.CODEC, Player.STREAM_CODEC),
        ENTITY(2, "entity", Entity.CODEC, Entity.STREAM_CODEC);

        public static final Codec<Type> CODEC;
        public static final IntFunction<Type> BY_ID;
        public static final StreamCodec<RegistryFriendlyByteBuf, Type> STREAM_CODEC;
        private final int id;
        private final String name;
        private final MapCodec<? extends Address> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, ? extends Address> streamCodec;

        private Type(int id, String name, MapCodec<? extends Address> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends Address> streamCodec) {
            this.id = id;
            this.name = name;
            this.codec = codec;
            this.streamCodec = streamCodec;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public MapCodec<? extends Address> getCodec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ? extends Address> getStreamCodec() {
            return this.streamCodec;
        }

        public MutableComponent translate() {
            return Component.translatable((String)("address.envelope.type." + this.getSerializedName()));
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal).cast();
        }
    }
}

