/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressFormatter {
    public static final int NEUTRAL_COLOR = -1651816;
    public static final int SENDER_COLOR = -8735263;
    public static final int RECIPIENT_COLOR = -1528457;
    protected final Address address;
    protected boolean icon = false;
    protected String iconSeparator = "\ueeff";
    protected Either<ChatFormatting, Style> iconStyle = Either.right((Object)Style.EMPTY);
    protected Either<ChatFormatting, Style> textStyle = Either.right((Object)Style.EMPTY);
    protected int maxLength = Integer.MAX_VALUE;

    protected AddressFormatter(Address address) {
        this.address = address;
    }

    public static AddressFormatter of(Address address) {
        return new AddressFormatter(address);
    }

    public AddressFormatter asNeutral() {
        return this.withIcon().withIconColor(-1651816).withColor(-1651816);
    }

    public AddressFormatter asSender() {
        return this.withIcon().withIconColor(-8735263).withColor(-8735263);
    }

    public AddressFormatter asRecipient() {
        return this.withIcon().withIconColor(-1528457).withColor(-1528457);
    }

    public AddressFormatter withIcon() {
        this.icon = true;
        return this;
    }

    public AddressFormatter withIconSeparator(String separator) {
        this.iconSeparator = separator;
        return this;
    }

    public AddressFormatter withIconColor(ChatFormatting formatting) {
        this.iconStyle = Either.left((Object)formatting);
        return this;
    }

    public AddressFormatter withIconStyle(Style style) {
        this.iconStyle = Either.right((Object)style);
        return this;
    }

    public AddressFormatter withIconColor(int color) {
        this.iconStyle = Either.right((Object)Style.EMPTY.withColor(color));
        return this;
    }

    public AddressFormatter withColor(ChatFormatting formatting) {
        this.textStyle = Either.left((Object)formatting);
        return this;
    }

    public AddressFormatter withStyle(Style style) {
        this.textStyle = Either.right((Object)style);
        return this;
    }

    public AddressFormatter withColor(int color) {
        this.textStyle = Either.right((Object)Style.EMPTY.withColor(color));
        return this;
    }

    public AddressFormatter withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public MutableComponent toComponent() {
        MutableComponent addressComponent;
        if (this.maxLength < Integer.MAX_VALUE) {
            String string = StringUtil.truncateStringIfNecessary((String)this.address.toString(), (int)this.maxLength, (boolean)true);
            addressComponent = Component.literal((String)string);
        } else {
            addressComponent = this.address.getName();
        }
        addressComponent = addressComponent.withStyle(this.createStyle(this.textStyle));
        if (this.icon) {
            return Component.empty().append((Component)Component.literal((String)AddressFormatter.getIcon(this.address)).withStyle(this.createStyle(this.iconStyle))).append(this.iconSeparator).append((Component)addressComponent);
        }
        return addressComponent;
    }

    public String toString() {
        String addressString = StringUtil.truncateStringIfNecessary((String)this.address.toString(), (int)this.maxLength, (boolean)true);
        String addressText = this.textStyle.left().map(formatting -> String.valueOf(formatting) + addressString + String.valueOf(ChatFormatting.RESET)).orElse(addressString);
        if (this.icon) {
            String icon = this.iconStyle.left().map(formatting -> String.valueOf(formatting) + AddressFormatter.getIcon(this.address) + String.valueOf(ChatFormatting.RESET)).orElse(AddressFormatter.getIcon(this.address));
            return icon + this.iconSeparator + addressText;
        }
        return addressText;
    }

    protected Style createStyle(Either<ChatFormatting, Style> style) {
        return (Style)style.map(arg_0 -> ((Style)Style.EMPTY).applyFormat(arg_0), Function.identity());
    }

    @NotNull
    public static String getIcon(Address address) {
        if (address.equals(Address.UNKNOWN)) {
            return "\uee03";
        }
        if (address.equals(Address.MAIL_SERVICE)) {
            return "\uee04";
        }
        return switch (address.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> "\uee00";
            case Address.Type.PLAYER -> "\uee01";
            case Address.Type.ENTITY -> "\uee02";
        };
    }

    @NotNull
    public static Component fullSender(@Nullable Address sender) {
        if (sender == null) {
            return CommonComponents.EMPTY;
        }
        return Component.translatable((String)"gui.envelope.mail.sender").withStyle(ChatFormatting.GRAY).append(": ").withStyle(ChatFormatting.GRAY).append((Component)sender.format().asSender().toComponent());
    }

    @NotNull
    public static Component fullRecipient(@Nullable Address recipient) {
        if (recipient == null) {
            return CommonComponents.EMPTY;
        }
        return Component.translatable((String)"gui.envelope.mail.recipient").withStyle(ChatFormatting.GRAY).append(": ").withStyle(ChatFormatting.GRAY).append((Component)recipient.format().asRecipient().toComponent());
    }

    @NotNull
    public static Component senderToRecipient(@Nullable Address sender, @Nullable Address recipient) {
        if (sender == null && recipient == null) {
            return CommonComponents.EMPTY;
        }
        if (sender != null) {
            if (recipient == null) {
                recipient = Address.UNKNOWN;
            }
            return sender.format().asSender().withMaxLength(25).toComponent().append((Component)Component.literal((String)" \uee21 ").withStyle(ChatFormatting.GRAY)).append((Component)recipient.format().asRecipient().withMaxLength(25).toComponent());
        }
        return recipient.format().asRecipient().toComponent();
    }
}

