/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.TravelDuration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface AddressLocation {
    public static final int ASCEND_DISTANCE = 16;
    public static final AddressLocation VIRTUAL = new AddressLocation(){

        @Override
        public Optional<BlockPos> getPosition() {
            return Optional.empty();
        }

        @Override
        public int getDistanceTo(BlockPos pos) {
            BlockPos virtualPos = Position.snapToGrid(pos, 2048);
            return Position.getDistanceBetween(virtualPos, pos);
        }
    };
    public static final AddressLocation UNKNOWN = new AddressLocation(){

        @Override
        public Optional<BlockPos> getPosition() {
            return Optional.empty();
        }

        @Override
        public int getDistanceTo(BlockPos pos) {
            return (Integer)Config.Server.DELIVERY_DEFAULT_DISTANCE.get();
        }
    };

    public Optional<BlockPos> getPosition();

    public int getDistanceTo(BlockPos var1);

    default public int getDistanceTo(Optional<BlockPos> pos) {
        return pos.map(this::getDistanceTo).orElse((Integer)Config.Server.DELIVERY_DEFAULT_DISTANCE.get());
    }

    default public TravelDuration getTravelDurationTo(BlockPos pos) {
        return TravelDuration.basedOnDistance(this.getDistanceTo(pos));
    }

    default public TravelDuration getTravelDurationTo(Optional<BlockPos> pos) {
        return TravelDuration.basedOnDistance(this.getDistanceTo(pos));
    }

    default public Optional<BlockPos> getNearestHub() {
        return this.getPosition().map(pos -> Position.snapToGrid(pos, 1024).atY(320));
    }

    default public Optional<BlockPos> ascendTowards(Level level, Optional<BlockPos> targetPos) {
        return this.getPosition().map(pos -> targetPos.map(blockPos -> Position.ascendTowards(pos, blockPos, 16)).orElseGet(() -> Position.towardsRandomHorizontalDirection(pos, 16, this.hashCode()))).map(pos -> Position.aboveGround(level, pos, 5));
    }

    public static AddressLocation exact(BlockPos pos) {
        return new Exact(pos);
    }

    public record Exact(@NotNull BlockPos pos) implements AddressLocation
    {
        @Override
        public Optional<BlockPos> getPosition() {
            return Optional.of(this.pos);
        }

        @Override
        public int getDistanceTo(BlockPos pos) {
            return Position.getDistanceBetween(this.pos, pos);
        }
    }
}

