/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressUniquifier {
    private static final Pattern VERSION_PATTERN = Pattern.compile("-(\\d+)$");
    protected final AllAddresses knownAddresses;

    public AddressUniquifier(AllAddresses knownAddresses) {
        this.knownAddresses = knownAddresses;
    }

    public String uniquify(String address) {
        if (!this.knownAddresses.isKnown(address)) {
            return address;
        }
        int number = 1;
        Matcher matcher = VERSION_PATTERN.matcher(address);
        if (matcher.find()) {
            try {
                number = Integer.parseInt(matcher.group(1));
                address = address.substring(0, matcher.start());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String candidate = address + "-" + number;
        while (this.knownAddresses.isKnown(candidate)) {
            candidate = address + "-" + ++number;
        }
        if (candidate.length() > 40) {
            String suffix = "-" + number;
            candidate = address.substring(0, 40 - suffix.length()) + suffix;
        }
        return candidate;
    }
}

