/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.util.validation.Rule;
import io.github.mortuusars.envelope.util.validation.Validator;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;

public interface AddressValidation {
    public static final Error CANNOT_BE_EMPTY = new Error("Id cannot be empty", "error.envelope.address.id_cannot_be_empty");
    public static final Error TOO_LONG = new Error("Id is too long", "error.envelope.address.id_too_long");
    public static final Error CONTAINS_INVALID_CHARS = new Error("Id is too long", "error.envelope.address.id_contains_invalid_chars");
    public static final Error TAKEN = new Error("Id is in use", "error.envelope.address.taken");
    public static final Error NOT_ENOUGH_XP = new Error("Not enough xp levels", "error.envelope.address.not_enough_xp_levels");
    public static final Validator<String> ID = Validator.of(Rule.when(StringUtil::isBlank, CANNOT_BE_EMPTY), Rule.when(id -> id.length() > 40, TOO_LONG), Rule.when(id -> !StringUtil.filterText((String)id).equals(id), CONTAINS_INVALID_CHARS));

    public static Validator<String> id() {
        return ID;
    }

    public static Validator<String> forMailbox(AllAddresses addresses, Player player) {
        return AddressValidation.id().and(AddressValidation.isNotTaken(addresses)).and(AddressValidation.hasEnoughXp(player, (Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get()));
    }

    public static Rule<String> isNotTaken(AllAddresses addresses) {
        return Rule.when(addresses::isKnown, TAKEN);
    }

    public static Rule<String> hasEnoughXp(Player player, int xpLevelsRequired) {
        return Rule.when(id -> !player.isCreative() && player.experienceLevel < xpLevelsRequired, NOT_ENOUGH_XP);
    }
}

