/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class PaybackDepartmentData
extends SavedData {
    public static final Codec<PaybackDepartmentData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap(Id.CODEC, PaybackSubject.CODEC).optionalFieldOf("payback_pending", Collections.emptyMap()).forGetter(PaybackDepartmentData::getPaybackPendingSubjects)).apply((Applicative)i, PaybackDepartmentData::new));
    private final Map<Id, PaybackSubject> paybackPendingSubjects;

    public PaybackDepartmentData(Map<Id, PaybackSubject> paybackPendingSubjects) {
        this.paybackPendingSubjects = new HashMap<Id, PaybackSubject>(paybackPendingSubjects);
    }

    public PaybackDepartmentData() {
        this.paybackPendingSubjects = new HashMap<Id, PaybackSubject>();
    }

    public Map<Id, PaybackSubject> getPaybackPendingSubjects() {
        return this.paybackPendingSubjects;
    }

    public static PaybackDepartmentData get(ServerLevel level, String name) {
        return (PaybackDepartmentData)level.getDataStorage().computeIfAbsent(PaybackDepartmentData.factory(), name);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.encode((Object)this, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot save PaybackDepartmentData: {}", (Object)e.message())).result().filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t).orElse(tag);
    }

    private static PaybackDepartmentData load(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot load PaybackDepartmentData: {}", (Object)e.message())).result().map(Pair::getFirst).orElseGet(PaybackDepartmentData::new);
    }

    private static SavedData.Factory<PaybackDepartmentData> factory() {
        return new SavedData.Factory(PaybackDepartmentData::new, PaybackDepartmentData::load, null);
    }
}

