/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.service;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.result.Result;
import io.github.mortuusars.envelope.world.block.mailbox.Mailboxes;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundDelivery;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.item.mail.MailBuilder;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressLocation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.mail.entity.MailEntities;
import io.github.mortuusars.envelope.world.mail.entity.MailEntity;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.MailServiceEntity;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackDepartment;
import io.github.mortuusars.envelope.world.mail.receiver.EntityMailReceiver;
import io.github.mortuusars.envelope.world.mail.receiver.MailboxMailReceiver;
import io.github.mortuusars.envelope.world.mail.receiver.PlayerMailReceiver;
import io.github.mortuusars.envelope.world.service.DeliveryManager;
import io.github.mortuusars.envelope.world.service.Players;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailService {
    protected final ServerLevel level;
    protected final Mailboxes mailboxes;
    protected final MailEntities mailEntities;
    protected final MailServiceEntity mailServiceEntity;
    protected final PaybackDepartment paybackDepartment;
    protected final DeliveryManager deliveryManager;
    @Nullable
    protected Players players;
    @Nullable
    protected BackgroundDelivery backgroundDelivery;

    private MailService(ServerLevel level) {
        Preconditions.checkArgument((level.dimension() == Level.OVERWORLD ? 1 : 0) != 0, (Object)"MailService can exist only on overworld level.");
        this.level = level;
        this.mailboxes = new Mailboxes(level);
        this.mailEntities = new MailEntities();
        this.mailServiceEntity = new MailServiceEntity(this);
        this.paybackDepartment = new PaybackDepartment(this);
        this.deliveryManager = new DeliveryManager(this);
        this.mailEntities.register(this.mailServiceEntity);
    }

    @ApiStatus.Internal
    public static MailService create(ServerLevel level) {
        return new MailService(level);
    }

    public static MailService of(ServerLevel level) {
        return level.getEnvelopeMailService();
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public Mailboxes getMailboxes() {
        return this.mailboxes;
    }

    public MailEntities getMailEntities() {
        return this.mailEntities;
    }

    public MailServiceEntity getMailService() {
        return this.mailServiceEntity;
    }

    public PaybackDepartment getPaybackDepartment() {
        return this.paybackDepartment;
    }

    @NotNull
    public Players getPlayers() {
        return this.players == null ? (this.players = Players.get(this.level, "envelope_players")) : this.players;
    }

    @NotNull
    public BackgroundDelivery getBackgroundDelivery() {
        return this.backgroundDelivery == null ? (this.backgroundDelivery = BackgroundDelivery.get(this.level, "envelope_background_delivery")) : this.backgroundDelivery;
    }

    public DeliveryManager getDeliveryManager() {
        return this.deliveryManager;
    }

    public AllAddresses getKnownAddresses() {
        return new AllAddresses(this.getMailboxes().getAllAddresses(), this.getPlayers().getDefaultAddresses().keySet(), this.getMailEntities().getAllAddresses());
    }

    public AllAddresses getKnownAddressesOfType(@Nullable Address.Type type) {
        if (type == null) {
            return this.getKnownAddresses();
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> AllAddresses.blocks(this.getMailboxes().getAllAddresses());
            case Address.Type.PLAYER -> AllAddresses.players(this.getPlayers().getDefaultAddresses().keySet());
            case Address.Type.ENTITY -> AllAddresses.entities(this.getMailEntities().getAllAddresses());
        };
    }

    public Optional<Address.Block> getPlayerDefaultAddress(Address.Player playerAddress) {
        return Optional.ofNullable(this.getPlayers().getDefaultAddresses().get(playerAddress));
    }

    public Address resolve(Address address) {
        if (address instanceof Address.Player) {
            Address.Player playerAddress = (Address.Player)address;
            return this.getPlayerDefaultAddress(playerAddress).map(Address.class::cast).orElse(address);
        }
        return address;
    }

    public AddressLocation getLocationOf(Address address) {
        return address.map(block -> this.getMailboxes().getPositionOf((Address.Block)block).map(AddressLocation::exact), player -> this.getPlayers().getDefaultAddressOf((Address.Player)player).map(this::getLocationOf), entity -> this.getMailEntities().byAddress((Address.Entity)entity).map(MailEntity::getLocation)).orElse(AddressLocation.UNKNOWN);
    }

    public ItemStack deliverMail(Address address, ItemStack mail) {
        if (mail.isEmpty()) {
            return mail;
        }
        return address.map(MailboxMailReceiver::new, PlayerMailReceiver::new, EntityMailReceiver::new).receiveMail(this.level, mail);
    }

    public void tick() {
        this.getBackgroundDelivery().tick(this.level);
        this.getPaybackDepartment().tick();
        if (this.level.getGameTime() % 20L == 0L) {
            Bugger.MAIL_SERVICE.collectAndSendData(this);
        }
    }

    public long getGameTime() {
        return this.getLevel().getGameTime();
    }

    public static boolean operatesIn(Level level) {
        return level.dimension() == Level.OVERWORLD;
    }

    public Result<DeliveryManager.StartedDelivery> sendCourierDeathNotice(LivingEntity entity, Delivery delivery, DamageSource damageSource) {
        Address address = delivery.getSender();
        if (!(address instanceof Address.Block)) {
            return null;
        }
        Address.Block address2 = (Address.Block)address;
        ItemStack letter = this.createCourierDeathNoticeLetter(entity, delivery, damageSource);
        return this.getDeliveryManager().startService(Delivery.draft().deliver(letter).from(Address.MAIL_SERVICE).to(address2));
    }

    public ItemStack createCourierDeathNoticeLetter(LivingEntity entity, Delivery delivery, DamageSource damageSource) {
        MutableComponent text = Component.empty().append((Component)Component.translatable((String)"letter.envelope.courier_death_notice.title").withStyle(ChatFormatting.ITALIC)).append((Component)Component.translatable((String)("letter.envelope.courier_death_notice.inform_" + entity.getRandom().nextInt(5)), (Object[])new Object[]{damageSource.getLocalizedDeathMessage(entity)})).append((Component)Component.translatable((String)("letter.envelope.courier_death_notice.delivery." + delivery.getPhase().getSerializedName()), (Object[])new Object[]{delivery.getRecipient().format().withIcon().withIconColor(-4889793).withColor(-4889793).toComponent()})).append((Component)(!delivery.getMail().isEmpty() ? Component.translatable((String)("letter.envelope.courier_death_notice.mail_lost_" + entity.getRandom().nextInt(6)), (Object[])new Object[]{delivery.getMail().getHoverName().copy().withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(delivery.getMail()))))}) : CommonComponents.EMPTY)).append((Component)Component.translatable((String)("letter.envelope.courier_death_notice.condolence_" + entity.getRandom().nextInt(5)), (Object[])new Object[]{entity.getName()})).append((Component)Component.translatable((String)"letter.envelope.courier_death_notice.signature"));
        return ((MailBuilder)Mail.createLetter((Component)text).set(DataComponents.CUSTOM_NAME, Component.translatable((String)"letter.envelope.courier_death_notice.name"))).get();
    }
}

