/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.service;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Players
extends SavedData {
    public static final Codec<Players> CODEC = Codec.unboundedMap((Codec)Codec.STRING, PlayerData.CODEC).xmap(Players::new, Players::getData);
    protected final Map<String, PlayerData> data;
    @Nullable
    protected Set<Address.Player> addresses;
    @Nullable
    protected Map<Address.Player, Address.Block> defaultAddresses;

    public Players(Map<String, PlayerData> data) {
        this.data = new HashMap<String, PlayerData>(data);
    }

    public Players() {
        this(Collections.emptyMap());
    }

    protected Map<String, PlayerData> getData() {
        return this.data;
    }

    public void add(Player player) {
        this.data.computeIfAbsent(player.getScoreboardName(), name -> new PlayerData(player.getGameProfile()));
        this.setDirty();
    }

    public void remove(String name) {
        if (this.data.remove(name) != null) {
            this.setDirty();
        }
    }

    public void clear() {
        this.data.clear();
        this.setDirty();
    }

    public Optional<PlayerData> getDataOf(String playerName) {
        return Optional.ofNullable(this.data.get(playerName));
    }

    public Optional<Address.Block> getDefaultAddressOf(Player player) {
        return this.getDataOf(player.getScoreboardName()).flatMap(PlayerData::getDefaultAddress);
    }

    public Optional<Address.Block> getDefaultAddressOf(Address.Player playerAddress) {
        return this.getDataOf(playerAddress.toString()).flatMap(PlayerData::getDefaultAddress);
    }

    public void setDefaultAddress(Player player, Address.Block address) {
        this.update(player, data -> data.setDefaultAddress(address));
    }

    public void renameDefaultAddress(Address.Block oldAddress, Address.Block newAddress) {
        this.getData().values().forEach(data -> {
            if (data.getDefaultAddress().map(a -> a.equals(oldAddress)).orElse(false).booleanValue()) {
                data.setDefaultAddress(newAddress);
            }
        });
        this.setDirty();
    }

    public void removeDefaultAddress(Address.Block address) {
        this.getData().values().forEach(data -> {
            if (data.getDefaultAddress().map(a -> a.equals(address)).orElse(false).booleanValue()) {
                data.setDefaultAddress(null);
            }
        });
        this.setDirty();
    }

    public void update(Player player, Consumer<PlayerData> updater) {
        this.data.compute(player.getScoreboardName(), (name, data) -> {
            if (data == null) {
                data = new PlayerData(player.getGameProfile());
            }
            updater.accept((PlayerData)data);
            return data;
        });
        this.setDirty();
    }

    @NotNull
    public Set<Address.Player> getAllAddresses() {
        if (this.addresses == null) {
            this.addresses = this.data.keySet().stream().map(Address.Player::new).collect(Collectors.toSet());
        }
        return this.addresses;
    }

    public Map<Address.Player, Address.Block> getDefaultAddresses() {
        if (this.defaultAddresses == null) {
            this.defaultAddresses = new HashMap<Address.Player, Address.Block>();
            this.getData().forEach((name, data) -> data.getDefaultAddress().ifPresent(defaultAddress -> this.defaultAddresses.put(data.getAddress(), (Address.Block)defaultAddress)));
        }
        return this.defaultAddresses;
    }

    public void setDirty() {
        super.setDirty();
        this.resetCache();
    }

    protected void resetCache() {
        this.addresses = null;
        this.defaultAddresses = null;
    }

    public static Players get(ServerLevel level, String name) {
        return (Players)level.getDataStorage().computeIfAbsent(Players.factory(), name);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot save KnownPlayers: {}", (Object)e.message())).result().filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t).orElse(tag);
    }

    private static Players load(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot load KnownPlayers: {}", (Object)e.message())).result().map(Pair::getFirst).orElseGet(Players::new);
    }

    private static SavedData.Factory<Players> factory() {
        return new SavedData.Factory(Players::new, Players::load, null);
    }

    public static class PlayerData {
        public static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.GAME_PROFILE_WITHOUT_PROPERTIES.codec().fieldOf("profile").forGetter(PlayerData::getProfile), (App)Address.Block.STRING_CODEC.optionalFieldOf("default_address").forGetter(PlayerData::getDefaultAddress)).apply((Applicative)i, PlayerData::new));
        protected final GameProfile profile;
        protected final Address.Player address;
        protected Optional<Address.Block> defaultAddress;

        public PlayerData(GameProfile profile, Optional<Address.Block> defaultAddress) {
            this.profile = profile;
            this.address = new Address.Player(profile.getName());
            this.defaultAddress = defaultAddress;
        }

        public PlayerData(GameProfile profile) {
            this(profile, Optional.empty());
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Address.Player getAddress() {
            return this.address;
        }

        public Optional<Address.Block> getDefaultAddress() {
            return this.defaultAddress;
        }

        public void setDefaultAddress(@Nullable Address.Block address) {
            this.defaultAddress = Optional.ofNullable(address);
        }
    }
}

