/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Register;
import io.github.mortuusars.envelope.command.argument.AddressArgument;
import io.github.mortuusars.envelope.util.DeferredSoundType;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.PackageBlock;
import io.github.mortuusars.envelope.world.block.PackageBlockEntity;
import io.github.mortuusars.envelope.world.block.PaperBoxBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.inventory.PackingMenu;
import io.github.mortuusars.envelope.world.inventory.PaybackPackingMenu;
import io.github.mortuusars.envelope.world.inventory.PaybackTagMenu;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.item.LetterAndQuillItem;
import io.github.mortuusars.envelope.world.item.LetterItem;
import io.github.mortuusars.envelope.world.item.MailboxBlockItem;
import io.github.mortuusars.envelope.world.item.PackageItem;
import io.github.mortuusars.envelope.world.item.PackingBoxItem;
import io.github.mortuusars.envelope.world.item.PaybackPackageItem;
import io.github.mortuusars.envelope.world.item.PaybackPackingBoxItem;
import io.github.mortuusars.envelope.world.item.PaybackTagItem;
import io.github.mortuusars.envelope.world.item.SealStampItem;
import io.github.mortuusars.envelope.world.item.SealedLetterItem;
import io.github.mortuusars.envelope.world.item.SealedPackageItem;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.LetterAndQuillContent;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.component.seal.SealImpression;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import io.github.mortuusars.envelope.world.item.crafting.LetterCloningRecipe;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3902;
import net.minecraft.class_3917;
import net.minecraft.class_4158;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Envelope {
    public static final String ID = "envelope";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Bugger.enabler = () -> Config.Server.SPEC.isLoaded() && (Boolean)Config.Server.DEBUG.get() != false;
        Blocks.init();
        BlockEntityTypes.init();
        PoiTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        Stats.init();
        CriteriaTriggers.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static class_2960 resource(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static boolean debug() {
        return (Boolean)Config.Server.DEBUG.get();
    }

    public static class Blocks {
        public static final Map<class_2960, Supplier<PigeonholeBlock>> PIGEONHOLES = new HashMap<class_2960, Supplier<PigeonholeBlock>>();
        public static final Supplier<PigeonholeBlock> OAK_PIGEONHOLE = Blocks.pigeonhole("oak", class_3620.field_15996);
        public static final Supplier<MailboxBlock> MAILBOX = Register.block("mailbox", () -> new MailboxBlock(class_4970.class_2251.method_9637().method_9632(4.0f).method_9626(class_2498.field_11547).method_31710(class_3620.field_15996)));
        public static final Supplier<PaperBoxBlock> PAPER_BOX = Register.block("paper_box", () -> new PaperBoxBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_50013().method_9632(0.3f).method_9626(SoundTypes.PAPER).method_31710(class_3620.field_15986)));
        public static final Supplier<PackageBlock> PACKAGE = Register.block("package", () -> new PackageBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_50013().method_9632(0.4f).method_9626(SoundTypes.PAPER).method_31710(class_3620.field_15986).method_22488()));
        public static final Supplier<PackageBlock> SEALED_PACKAGE = Register.block("sealed_package", () -> new PackageBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_50013().method_9632(0.4f).method_9626(SoundTypes.PAPER).method_31710(class_3620.field_15986).method_22488()));

        private static Supplier<PigeonholeBlock> pigeonhole(String type, class_3620 color) {
            String id = type + "_pigeonhole";
            Supplier<PigeonholeBlock> block = Register.block(id, () -> new PigeonholeBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_20422).method_9632(2.0f).method_31710(color)));
            PIGEONHOLES.put(Envelope.resource(id), block);
            return block;
        }

        static void init() {
        }
    }

    public static class BlockEntityTypes {
        public static final Supplier<class_2591<MailboxBlockEntity>> MAILBOX = Register.blockEntityType("mailbox", () -> Register.newBlockEntityType(MailboxBlockEntity::new, (class_2248)Blocks.MAILBOX.get()));
        public static final Supplier<class_2591<PigeonholeBlockEntity>> PIGEONHOLE = Register.blockEntityType("pigeonhole", () -> Register.newBlockEntityType(PigeonholeBlockEntity::new, (class_2248[])BlockEntityTypes.getPigeonholeBlocks()));
        public static final Supplier<class_2591<PackageBlockEntity>> PACKAGE = Register.blockEntityType("package", () -> Register.newBlockEntityType(PackageBlockEntity::new, Blocks.PACKAGE.get(), Blocks.SEALED_PACKAGE.get()));

        private static PigeonholeBlock[] getPigeonholeBlocks() {
            return (PigeonholeBlock[])Blocks.PIGEONHOLES.values().stream().map(Supplier::get).toArray(PigeonholeBlock[]::new);
        }

        static void init() {
        }
    }

    public static class PoiTypes {
        public static final class_5321<class_4158> PIGEONHOLE = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)Envelope.resource("pigeonhole"));
        public static final class_5321<class_4158> MAILBOX = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)Envelope.resource("mailbox"));

        static void init() {
            Register.poiType(PIGEONHOLE, 0, 1, PoiTypes::getPigeonholePoiBlockStates);
            Register.poiType(MAILBOX, 0, 1, PoiTypes::getMailboxPoiBlockStates);
        }

        private static Set<class_2680> getPigeonholePoiBlockStates() {
            return Blocks.PIGEONHOLES.values().stream().map(Supplier::get).map(b -> b.method_9595().method_11662()).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private static Set<class_2680> getMailboxPoiBlockStates() {
            return Set.copyOf(Blocks.MAILBOX.get().method_9595().method_11662());
        }
    }

    public static class EntityTypes {
        public static final Supplier<class_1299<Pigeon>> PIGEON = Register.entityType("pigeon", Pigeon::new, class_1311.field_6294, true, builder -> builder.method_17687(0.65f, 0.85f).method_55687(0.59375f).method_55689(new float[]{0.4625f}).method_27299(8));

        static void init() {
        }
    }

    public static class Items {
        public static final List<Supplier<class_1747>> PIGEONHOLES = new ArrayList<Supplier<class_1747>>();
        public static final Supplier<class_1747> OAK_PIGEONHOLE = Items.pigeonhole("oak", Blocks.OAK_PIGEONHOLE);
        public static final Supplier<LetterAndQuillItem> LETTER_AND_QUILL = Register.item("letter_and_quill", () -> new LetterAndQuillItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<LetterItem> LETTER = Register.item("letter", () -> new LetterItem(new class_1792.class_1793()));
        public static final Supplier<SealedLetterItem> SEALED_LETTER = Register.item("sealed_letter", () -> new SealedLetterItem(new class_1792.class_1793()));
        public static final Supplier<class_1747> PAPER_BOX = Register.item("paper_box", () -> new class_1747((class_2248)Blocks.PAPER_BOX.get(), new class_1792.class_1793()));
        public static final Supplier<PackingBoxItem> PACKING_BOX = Register.item("packing_box", () -> new PackingBoxItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PackageItem> PACKAGE = Register.item("package", () -> new PackageItem(Blocks.PACKAGE.get(), new class_1792.class_1793().method_7889(1)));
        public static final Supplier<SealedPackageItem> SEALED_PACKAGE = Register.item("sealed_package", () -> new SealedPackageItem(Blocks.SEALED_PACKAGE.get(), new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PaybackTagItem> PAYBACK_TAG = Register.item("payback_tag", () -> new PaybackTagItem(new class_1792.class_1793()));
        public static final Supplier<PaybackPackingBoxItem> PAYBACK_PACKING_BOX = Register.item("payback_packing_box", () -> new PaybackPackingBoxItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<PaybackPackageItem> PAYBACK_PACKAGE = Register.item("payback_package", () -> new PaybackPackageItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<AddressTagItem> ADDRESS_TAG = Register.item("address_tag", () -> new AddressTagItem(new class_1792.class_1793()));
        public static final Supplier<SealStampItem> SEAL_STAMP = Register.item("seal_stamp", () -> new SealStampItem(new class_1792.class_1793().method_7889(1)));
        public static final Supplier<class_1826> PIGEON_SPAWN_EGG = Register.item("pigeon_spawn_egg", () -> new class_1826(EntityTypes.PIGEON.get(), 6776705, 0xB8B8CB, new class_1792.class_1793()));
        public static final Supplier<MailboxBlockItem> MAILBOX = Register.item("mailbox", () -> new MailboxBlockItem((class_2248)Blocks.MAILBOX.get(), new class_1792.class_1793()));

        @NotNull
        private static Supplier<class_1747> pigeonhole(String type, Supplier<PigeonholeBlock> block) {
            Supplier<class_1747> item = Register.item(type + "_pigeonhole", () -> new class_1747((class_2248)block.get(), new class_1792.class_1793()));
            PIGEONHOLES.add(item);
            return item;
        }

        static void init() {
        }
    }

    public static class DataComponents {
        public static final class_9331<Address> ADDRESS = Register.dataComponentType("address", b -> b.method_57881(Address.CODEC).method_57882(Address.STREAM_CODEC));
        public static final class_9331<Id> MAIL_ID = Register.dataComponentType("mail_id", b -> b.method_57881(Id.CODEC).method_57882(Id.STREAM_CODEC));
        public static final class_9331<Address> MAIL_RECIPIENT = Register.dataComponentType("mail_recipient", b -> b.method_57881(Address.CODEC).method_57882(Address.STREAM_CODEC));
        public static final class_9331<RequestedPayback> MAIL_REQUESTED_PAYBACK = Register.dataComponentType("mail_requested_payback", b -> b.method_57881(RequestedPayback.CODEC).method_57882(RequestedPayback.STREAM_CODEC));
        public static final class_9331<DeliveryLog> MAIL_DELIVERY_LOG = Register.dataComponentType("mail_delivery_log", b -> b.method_57881(DeliveryLog.CODEC).method_57882(DeliveryLog.STREAM_CODEC));
        public static final class_9331<class_3902> MAIL_RETURNED = Register.dataComponentType("mail_returned", b -> b.method_57881(class_3902.field_51563).method_57882(class_9139.method_56431((Object)class_3902.field_17274)));
        public static final class_9331<Address> MAIL_SENDER = Register.dataComponentType("mail_sender", b -> b.method_57881(Address.CODEC).method_57882(Address.STREAM_CODEC));
        public static final class_9331<LetterAndQuillContent> LETTER_AND_QUILL_CONTENT = Register.dataComponentType("letter_and_quill_content", b -> b.method_57881(LetterAndQuillContent.CODEC).method_57882(LetterAndQuillContent.STREAM_CODEC));
        public static final class_9331<LetterContent> LETTER_CONTENT = Register.dataComponentType("letter_content", b -> b.method_57881(LetterContent.CODEC).method_57882(LetterContent.STREAM_CODEC));
        public static final class_9331<class_3902> LETTER_TATTERED = Register.dataComponentType("letter_tattered", b -> b.method_57881(class_3902.field_51563).method_57882(class_9139.method_56431((Object)class_3902.field_17274)));
        public static final class_9331<PackageContents> PACKAGE_CONTENTS = Register.dataComponentType("package_contents", b -> b.method_57881(PackageContents.CODEC).method_57882(PackageContents.STREAM_CODEC));
        public static final class_9331<Integer> PACKAGE_TIMES_PACKED = Register.dataComponentType("package_times_packed", b -> b.method_57881((Codec)Codec.INT).method_57882(class_9135.field_48550));
        public static final class_9331<Seal> SEAL = Register.dataComponentType("seal", b -> b.method_57881(Seal.CODEC).method_57882(Seal.STREAM_CODEC));
        public static final class_9331<class_6880<SealImpression>> SEAL_STAMP_IMPRESSION = Register.dataComponentType("seal_stamp_impression", b -> b.method_57881(SealImpression.CODEC).method_57882(SealImpression.STREAM_CODEC));
        public static final class_9331<PaybackTagContents> PAYBACK_TAG_CONTENTS = Register.dataComponentType("payback_tag_contents", b -> b.method_57881(PaybackTagContents.CODEC).method_57882(PaybackTagContents.STREAM_CODEC));
        public static final class_9331<PaybackSubject> PAYBACK_SUBJECT = Register.dataComponentType("payback_subject", b -> b.method_57881(PaybackSubject.CODEC).method_57882(PaybackSubject.STREAM_CODEC));
        public static final class_9331<List<Occupant>> PIGEONS = Register.dataComponentType("pigeons", b -> b.method_57881(Occupant.LIST_CODEC).method_57882(Occupant.STREAM_CODEC.method_56433(class_9135.method_56363())).method_59871());

        static void init() {
        }
    }

    public static class Stats {
        public static void init() {
        }
    }

    public static class CriteriaTriggers {
        public static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static void init() {
        }
    }

    public static class MenuTypes {
        public static final Supplier<class_3917<MailboxMenu>> PIGEONHOLE = Register.menuType("pigeonhole", MailboxMenu::fromNetwork);
        public static final Supplier<class_3917<PackingMenu>> PACKAGE = Register.menuType("package", PackingMenu::fromNetwork);
        public static final Supplier<class_3917<PaybackPackingMenu>> PAYBACK_PACKAGE = Register.menuType("payback_package", PaybackPackingMenu::fromNetwork);
        public static final Supplier<class_3917<PaybackTagMenu>> PAYBACK_TAG = Register.menuType("payback_tag", PaybackTagMenu::fromNetwork);

        static void init() {
        }
    }

    public static class RecipeSerializers {
        public static final Supplier<class_1865<?>> LETTER_CLONING = Register.recipeSerializer("crafting_special_letter_cloning", () -> new class_1866(LetterCloningRecipe::new));

        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<class_3414> PAPER_TEAR = SoundEvents.register("item", "paper.tear");
        public static final Supplier<class_3414> PAPER_CRACKLE = SoundEvents.register("item", "paper.crackle");
        public static final Supplier<class_3414> PAPER_PLACE = SoundEvents.register("block", "paper.place");
        public static final Supplier<class_3414> PAPER_BREAK = SoundEvents.register("block", "paper.break");
        public static final Supplier<class_3414> PAPER_HIT = SoundEvents.register("block", "paper.hit");
        public static final Supplier<class_3414> PAPER_FALL = SoundEvents.register("block", "paper.fall");
        public static final Supplier<class_3414> PAPER_STEP = SoundEvents.register("block", "paper.step");
        public static final Supplier<class_3414> PAPER_USE = SoundEvents.register("block", "paper.use");
        public static final Supplier<class_3414> PIGEON_AMBIENT = SoundEvents.register("entity", "pigeon.ambient");
        public static final Supplier<class_3414> PIGEON_DEATH = SoundEvents.register("entity", "pigeon.death");
        public static final Supplier<class_3414> PIGEON_EAT = SoundEvents.register("entity", "pigeon.eat");
        public static final Supplier<class_3414> PIGEON_FLY = SoundEvents.register("entity", "pigeon.fly");
        public static final Supplier<class_3414> PIGEON_HURT = SoundEvents.register("entity", "pigeon.hurt");
        public static final Supplier<class_3414> PIGEON_STEP = SoundEvents.register("entity", "pigeon.step");

        private static Supplier<class_3414> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> class_3414.method_47908((class_2960)Envelope.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static final Supplier<class_2314<AddressArgument, class_2319.class_7219>> ADDRESS = Register.commandArgumentType("address", AddressArgument.class, class_2319.method_41999(AddressArgument::all));

        public static void init() {
        }
    }

    public static class Registries {
        public static final class_5321<class_2378<SealMaterial>> SEAL_MATERIAL = class_5321.method_29180((class_2960)Envelope.resource("seal_material"));
        public static final class_5321<class_2378<SealImpression>> SEAL_IMPRESSION = class_5321.method_29180((class_2960)Envelope.resource("seal_impression"));
    }

    public static class Tags {

        public static class SealImpressions {
            public static final class_6862<SealImpression> SPECIAL = class_6862.method_40092(Registries.SEAL_IMPRESSION, (class_2960)Envelope.resource("special"));
            public static final class_6862<SealImpression> TOOLS = class_6862.method_40092(Registries.SEAL_IMPRESSION, (class_2960)Envelope.resource("tools"));
        }

        public static class Structures {
            public static final class_6862<class_3195> PIGEONS_SPAWN_IN = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)Envelope.resource("pigeons_spawn_in"));
        }

        public static class Biomes {
            public static final class_6862<class_1959> ALLOWS_PIGEON_SPAWNS = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Envelope.resource("allows_pigeon_spawns"));
            public static final class_6862<class_1959> HAS_PASSENGER_PIGEONS = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Envelope.resource("has_passenger_pigeons"));
        }

        public static class DamageTypes {
            public static final class_6862<class_8110> BYPASSES_PIGEON_DELIVERY_EVASION = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)Envelope.resource("bypasses_pigeon_delivery_evasion"));
        }

        public static class EntityTypes {
            public static final class_6862<class_1299<?>> PIGEONHOLE_INHABITORS = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)Envelope.resource("pigeonhole_inhabitors"));
        }

        public static class Items {
            public static final class_6862<class_1792> PIGEON_FOOD = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("pigeon_food"));
            public static final class_6862<class_1792> PIGEONHOLES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("pigeonholes"));
            public static final class_6862<class_1792> WASTE_SCOOPABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("waste_scoopable"));
            public static final class_6862<class_1792> LETTERS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("letters"));
            public static final class_6862<class_1792> PACKAGES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("packages"));
            public static final class_6862<class_1792> MAILABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("mailable"));
            public static final class_6862<class_1792> CANNOT_BE_PACKAGED = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("cannot_be_packaged"));
            public static final class_6862<class_1792> CANNOT_BE_USED_AS_PAYBACK = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Envelope.resource("cannot_be_used_as_payback"));
        }

        public static class Blocks {
            public static final class_6862<class_2248> PIGEONS_SPAWNABLE_ON = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Envelope.resource("pigeons_spawnable_on"));
            public static final class_6862<class_2248> PIGEONHOLES = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Envelope.resource("pigeonholes"));
        }
    }

    public static class LootTables {
    }

    public static class SoundTypes {
        public static final class_2498 PAPER = new DeferredSoundType(1.0f, 1.0f, SoundEvents.PAPER_BREAK, SoundEvents.PAPER_STEP, SoundEvents.PAPER_PLACE, SoundEvents.PAPER_HIT, SoundEvents.PAPER_FALL);
    }
}

