/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.tooltip.CompositeTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.MailAddressTagTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PackageTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PaybackTagContentsTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PaybackTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.SealDieTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.SealTooltipComponent;
import io.github.mortuusars.envelope.client.renderer.SealRenderer;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.bugger.BuggerDebugScreen;
import io.github.mortuusars.envelope.util.bugger.BuggerEntityOverhead;
import io.github.mortuusars.envelope.util.bugger_data.EnvelopeBuggerPage;
import io.github.mortuusars.envelope.util.bugger_data.PigeonEntityDataDisplay;
import io.github.mortuusars.envelope.world.item.component.LetterAndQuillContent;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.item.tooltip.CompositeTooltip;
import io.github.mortuusars.envelope.world.item.tooltip.MailAddressTagTooltip;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class EnvelopeClient {
    private static final SealRenderer sealRenderer = new SealRenderer();

    public static void init() {
        BuggerDebugScreen.addPage(new EnvelopeBuggerPage());
        BuggerEntityOverhead.addData(new PigeonEntityDataDisplay());
        ItemModelOverrides.register();
    }

    public static SealRenderer getSealRenderer() {
        return sealRenderer;
    }

    public static class ItemModelOverrides {
        public static final class_2960 LETTER_TATTERED = Envelope.resource("letter_tattered");
        public static final class_2960 LETTER_UNFOLDED = Envelope.resource("letter_unfolded");
        public static final class_2960 LETTER_CONTENT = Envelope.resource("letter_content");

        public static void register() {
            class_5272.method_27879((class_1792)Envelope.Items.LETTER_AND_QUILL.get(), (class_2960)LETTER_CONTENT, ItemModelOverrides::hasLetterContent);
            class_5272.method_27879((class_1792)Envelope.Items.LETTER.get(), (class_2960)LETTER_TATTERED, ItemModelOverrides::isLetterTattered);
            class_5272.method_27879((class_1792)Envelope.Items.LETTER.get(), (class_2960)LETTER_UNFOLDED, ItemModelOverrides::isLetterUnfolded);
            class_5272.method_27879((class_1792)Envelope.Items.LETTER.get(), (class_2960)LETTER_CONTENT, ItemModelOverrides::hasLetterContent);
            class_5272.method_27879((class_1792)Envelope.Items.SEALED_LETTER.get(), (class_2960)LETTER_TATTERED, ItemModelOverrides::isLetterTattered);
        }

        public static float isLetterTattered(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            return stack.method_57826(Envelope.DataComponents.LETTER_TATTERED) ? 1.0f : 0.0f;
        }

        public static float isLetterUnfolded(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            LetterContent content = (LetterContent)stack.method_57825(Envelope.DataComponents.LETTER_CONTENT, (Object)LetterContent.EMPTY);
            return content.unfolded() ? 1.0f : 0.0f;
        }

        public static float hasLetterContent(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            if (!((LetterAndQuillContent)stack.method_57825(Envelope.DataComponents.LETTER_AND_QUILL_CONTENT, (Object)LetterAndQuillContent.EMPTY)).isEmpty()) {
                return 1.0f;
            }
            if (!((LetterContent)stack.method_57825(Envelope.DataComponents.LETTER_CONTENT, (Object)LetterContent.EMPTY)).isEmpty()) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    public static class TooltipComponents {
        public static class_5684 create(class_5632 component) {
            class_5632 class_56322 = component;
            Objects.requireNonNull(class_56322);
            class_5632 class_56323 = class_56322;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MailAddressTagTooltip.class, PackageContents.class, RequestedPayback.class, PaybackTagContents.class, Seal.class, io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent.class, CompositeTooltip.class}, (Object)class_56323, n)) {
                case 0 -> {
                    MailAddressTagTooltip mailAddress = (MailAddressTagTooltip)class_56323;
                    yield new MailAddressTagTooltipComponent(mailAddress.address());
                }
                case 1 -> {
                    PackageContents packageContents = (PackageContents)class_56323;
                    yield new PackageTooltipComponent(packageContents);
                }
                case 2 -> {
                    RequestedPayback requestedPayback = (RequestedPayback)class_56323;
                    yield new PaybackTooltipComponent(requestedPayback);
                }
                case 3 -> {
                    PaybackTagContents paybackTagContents = (PaybackTagContents)class_56323;
                    yield new PaybackTagContentsTooltipComponent(paybackTagContents);
                }
                case 4 -> {
                    Seal seal = (Seal)class_56323;
                    yield new SealTooltipComponent(seal);
                }
                case 5 -> {
                    io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent die = (io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent)class_56323;
                    yield new SealDieTooltipComponent(die.impression());
                }
                case 6 -> {
                    CompositeTooltip composite = (CompositeTooltip)class_56323;
                    yield new CompositeTooltipComponent(composite.components().stream().map(class_5684::method_32663).toList());
                }
                default -> null;
            };
        }

        public static Optional<class_5632> modifyTooltipImage(class_1799 stack, Optional<class_5632> original) {
            if (stack.method_31573(Envelope.Tags.Items.MAILABLE)) {
                return CompositeTooltip.of(original, Optional.ofNullable((Address)stack.method_57824(Envelope.DataComponents.MAIL_RECIPIENT)).map(MailAddressTagTooltip::new), Optional.ofNullable((class_5632)stack.method_57824(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK)));
            }
            return original;
        }

        public static void appendTooltipLines(class_1799 stack, Consumer<class_2561> consumer, class_1792.class_9635 context, class_1657 player, class_1836 tooltipFlag) {
            Mail.getSender(stack).ifPresent(sender -> {
                DeliveryLog deliveryLog = Mail.getLog(stack);
                if (class_437.method_25442() && !deliveryLog.isEmpty()) {
                    consumer.accept((class_2561)class_2561.method_43471((String)"gui.envelope.delivery_log").method_27692(class_124.field_1063));
                    for (DeliveryRecord record : deliveryLog.records()) {
                        consumer.accept((class_2561)record.toComponent(Minecrft.level().method_8510()));
                    }
                } else {
                    consumer.accept((class_2561)class_2561.method_43471((String)"gui.envelope.mail.from").method_27692(class_124.field_1080).method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)sender.format().asNeutral().toComponent()));
                }
            });
            if (tooltipFlag.method_8035()) {
                Optional.ofNullable(Mail.getId(stack)).ifPresent(id -> consumer.accept((class_2561)class_2561.method_43470((String)("Mail Id: " + String.valueOf(id))).method_27692(class_124.field_1080)));
            }
        }
    }
}

