/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.screen.AddressTagScreen;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.validation.CachedValidator;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMailboxAddressScreen
extends AddressTagScreen {
    protected final class_746 player = Minecrft.player();
    protected CachedValidator<String> addressValidator;

    public AbstractMailboxAddressScreen(class_1268 hand, AllAddresses knownAddresses, Optional<Address.Block> existingAddress, class_2561 title) {
        super(hand, knownAddresses, title);
        this.existingAddress = existingAddress.map(Address.class::cast);
        this.addressValidator = AddressValidation.forMailbox(knownAddresses, (class_1657)this.player).cached();
    }

    @Override
    protected abstract class_1799 getTargetPreview();

    protected abstract void onConfirm();

    protected abstract boolean stillValid();

    @Override
    protected String getInitialAddressValue() {
        return this.existingAddress.map(Address::id).orElseGet(() -> Optional.ofNullable((Address)this.player.method_5998(this.hand).method_57824(Envelope.DataComponents.ADDRESS)).map(Address::getName).map(class_2561::getString).orElse(""));
    }

    @Override
    protected AllAddresses getAddressesForSuggestions() {
        return AllAddresses.EMPTY;
    }

    public CachedValidator<String> getAddressValidator() {
        return this.addressValidator;
    }

    protected boolean canConfirm() {
        return this.isCurrentIdSameAsExistingAddress() || this.getAddressValidator().getErrors().isEmpty();
    }

    protected void updateConfirmButton() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.field_22763 = this.canConfirm();
        class_5250 confirmTooltip = class_2561.method_43471((String)"gui.envelope.confirm");
        if (!this.confirmButton.field_22763) {
            this.getAddressValidator().getErrors().forEach(issue -> confirmTooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1061)).method_10852((class_2561)issue.getTranslation().method_27692(class_124.field_1061)));
            this.confirmButton.method_47400(class_7919.method_47407((class_2561)confirmTooltip));
            return;
        }
        if (this.isRenaming() && !this.isCurrentIdSameAsExistingAddress()) {
            confirmTooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox_address.rename_warning.inbox").method_27696(class_2583.field_24360.method_36139(-1611158))).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox_address.rename_warning.traveling").method_27696(class_2583.field_24360.method_36139(-1611158)));
        }
        this.confirmButton.method_47400(class_7919.method_47407((class_2561)confirmTooltip));
    }

    @Override
    protected void addressTextChanged(String text) {
        super.addressTextChanged(text);
        this.getAddressValidator().testAll(this.getCurrentAddressId());
    }

    @Override
    protected boolean confirm() {
        if (!this.canConfirm()) {
            return false;
        }
        if (!this.isCurrentIdSameAsExistingAddress()) {
            this.onConfirm();
        }
        this.close();
        return true;
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.stillValid()) {
            this.close();
        }
        this.updateConfirmButton();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderExperienceCost(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderAddressIcon(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int color = this.canConfirm() ? -1 : -1426063361;
        guiGraphics.method_51433(this.field_22793, "\uee00", this.leftPos + 17, this.topPos + 21, color, true);
    }

    protected void renderExperienceCost(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isCurrentIdSameAsExistingAddress() || this.player.method_7337()) {
            return;
        }
        int cost = (Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get();
        if (cost <= 0) {
            return;
        }
        boolean hasEnough = this.player.field_7520 >= cost;
        class_2960 sprite = Envelope.resource("address_tag/experience" + (hasEnough ? "" : "_disabled"));
        int x = 159;
        int y = 4;
        guiGraphics.method_52706(sprite, this.leftPos + x, this.topPos + y, 11, 11);
        String text = Integer.toString(cost);
        int centerColor = hasEnough ? -3604593 : -7577507;
        int outlineColor = hasEnough ? -13819646 : -12110545;
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + (x += 7), this.topPos + (y += 2) - 1, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x + 1, this.topPos + y - 1, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x + 1, this.topPos + y, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x + 1, this.topPos + y + 1, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x, this.topPos + y + 1, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x - 1, this.topPos + y + 1, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x - 1, this.topPos + y, outlineColor, false);
        guiGraphics.method_51433(this.field_22793, text, this.leftPos + x, this.topPos + y, centerColor, false);
    }
}

