/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.gui.widget.AddressBoxSuggestions;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.AddressTagApplyC2SP;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressTagScreen
extends class_437 {
    public static final class_2960 TEXTURE = Envelope.resource("textures/gui/address_tag.png");
    public static final class_8666 CONFIRM_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("address_tag/confirm_button"));
    protected final class_1268 hand;
    protected final class_1799 tag;
    protected final AllAddresses knownAddresses;
    protected Optional<Address> existingAddress;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int titleLabelX;
    protected int titleLabelY;
    protected class_342 addressBox;
    protected AddressBoxSuggestions suggestions;
    protected class_344 confirmButton;
    protected Optional<Address> matchedKnownAddress = Optional.empty();
    @Nullable
    protected String currentSuggestion;

    public AddressTagScreen(class_1268 hand, AllAddresses knownAddresses, class_2561 title) {
        super(title);
        this.hand = hand;
        this.tag = Minecrft.player().method_5998(hand).method_7972();
        this.knownAddresses = knownAddresses;
        this.existingAddress = Optional.ofNullable((Address)this.tag.method_57824(Envelope.DataComponents.ADDRESS));
    }

    protected void method_25426() {
        this.imageWidth = 186;
        this.imageHeight = 40;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.titleLabelX = this.leftPos + 12;
        this.titleLabelY = this.topPos + 6;
        this.addressBox = new class_342(this.field_22793, this.leftPos + 26, this.topPos + 21, 125, 9, (class_2561)class_2561.method_43473());
        this.addressBox.method_1852(this.getInitialAddressValue());
        this.addressBox.method_1880(40);
        this.addressBox.method_1868(-1);
        this.addressBox.method_1863(this::addressTextChanged);
        this.addressBox.method_1858(false);
        this.addressBox.method_1856(false);
        this.method_37063((class_364)this.addressBox);
        this.suggestions = new AddressBoxSuggestions(this.addressBox, this.getAddressesForSuggestions(), 6);
        this.suggestions.update();
        this.confirmButton = new class_344(this.leftPos + 158, this.topPos + 17, 16, 16, CONFIRM_BUTTON_SPRITES, button -> this.confirm(), (class_2561)class_2561.method_43471((String)"gui.envelope.confirm"));
        this.confirmButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.envelope.confirm")));
        this.method_37063((class_364)this.confirmButton);
        this.method_48265((class_364)this.addressBox);
        this.addressTextChanged(this.addressBox.method_1882());
    }

    protected class_1799 getTargetPreview() {
        return this.tag;
    }

    protected String getCurrentAddressId() {
        return this.addressBox.method_1882().trim();
    }

    protected String getInitialAddressValue() {
        @Nullable Address address = (Address)this.tag.method_57824(Envelope.DataComponents.ADDRESS);
        if (address != null) {
            return address.toString();
        }
        return "";
    }

    protected Optional<Address> getMatchedKnownAddress() {
        return this.matchedKnownAddress;
    }

    protected Optional<Address> getOrCreateAddressFromCurrentValue() {
        String addressId = this.getCurrentAddressId().trim();
        if (addressId.isBlank()) {
            return Optional.empty();
        }
        return this.getMatchedKnownAddress().or(() -> Optional.of(new Address.Block(addressId)));
    }

    protected AllAddresses getAddressesForSuggestions() {
        return this.knownAddresses;
    }

    protected boolean isRenaming() {
        return this.existingAddress.isPresent();
    }

    protected boolean isCurrentIdSameAsExistingAddress() {
        String currentAddressId = this.getCurrentAddressId().trim();
        return this.existingAddress.map(address -> address.matches(currentAddressId)).orElse(false);
    }

    protected void updateItem() {
        this.getOrCreateAddressFromCurrentValue().ifPresentOrElse(value -> this.tag.method_57379(Envelope.DataComponents.ADDRESS, value), () -> this.tag.method_57381(Envelope.DataComponents.ADDRESS));
    }

    protected void addressTextChanged(String text) {
        String addressId = text.trim();
        this.matchedKnownAddress = this.knownAddresses.byName(addressId);
        this.updateItem();
        this.suggestions.update();
    }

    protected boolean confirm() {
        if (!this.isCurrentIdSameAsExistingAddress()) {
            Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17484, (float)1.0f));
            int slot = this.hand == class_1268.field_5808 ? Minecrft.player().method_31548().field_7545 : 40;
            Packets.sendToServer(new AddressTagApplyC2SP(slot, this.getOrCreateAddressFromCurrentValue()));
        }
        this.close();
        return true;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String text = this.addressBox.method_1882();
        int cursorPosition = this.addressBox.method_1881();
        super.method_25410(minecraft, width, height);
        this.addressBox.method_1852(text);
        this.addressBox.method_1875(cursorPosition);
        this.suggestions.update();
    }

    protected void close() {
        this.method_25419();
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        this.suggestions.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
        this.renderLabels(guiGraphics);
        this.renderAddressIcon(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTargetPreview(guiGraphics, mouseX, mouseY);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        guiGraphics.method_25302(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@NotNull class_332 guiGraphics) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.titleLabelX, this.titleLabelY, -12829636, false);
    }

    protected void renderAddressIcon(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Address address = this.getMatchedKnownAddress().orElse(Address.UNKNOWN);
        int color = !address.equals(Address.UNKNOWN) ? -5438 : -1996494142;
        guiGraphics.method_51433(this.field_22793, AddressFormatter.getIcon(address), this.leftPos + 17, this.topPos + 21, color, true);
        if (address != Address.UNKNOWN && this.isHovering(15, 20, 9, 9, mouseX, mouseY)) {
            guiGraphics.method_51438(this.field_22793, (class_2561)address.type().translate(), mouseX, mouseY);
        }
    }

    protected void renderTargetPreview(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        class_1799 target = this.getTargetPreview();
        if (target.method_7960()) {
            return;
        }
        float scale = 2.0f;
        int size = (int)(16.0f * scale);
        int x = this.leftPos - size - 4;
        int y = this.topPos + (this.imageHeight - size) / 2;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416(-8.0f, -8.0f, 0.0f);
        guiGraphics.method_51427(target, 0, 0);
        guiGraphics.method_51448().method_22909();
        if (this.isHovering(x - this.leftPos, y - this.topPos, size, size, mouseX, mouseY)) {
            guiGraphics.method_51446(this.field_22793, target, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.confirm()) {
                Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            return true;
        }
        if (keyCode == 258 && this.currentSuggestion != null) {
            this.addressBox.method_1852(this.currentSuggestion);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.suggestions.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1 && this.addressBox.method_25405(mouseX, mouseY)) {
            if (!this.addressBox.method_1882().isEmpty()) {
                this.addressBox.method_1852("");
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.suggestions.method_16014(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.suggestions.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25421() {
        return false;
    }

    public int getSuggestionTextColor() {
        return -1996488705;
    }

    protected boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= this.leftPos + x && mouseX < this.leftPos + x + width && mouseY >= this.topPos + y && mouseY < this.topPos + y + height;
    }
}

