/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.LetterViewScreenClosedS2CP;
import io.github.mortuusars.envelope.util.ItemAndStack;
import io.github.mortuusars.envelope.world.item.LetterItem;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class LetterViewScreen
extends class_437 {
    public static final class_2960 REGULAR_TEXTURE = Envelope.resource("textures/gui/letter.png");
    public static final class_2960 TATTERED_TEXTURE = Envelope.resource("textures/gui/letter_tattered.png");
    public static final class_2960 TATTERED_OVERLAY = Envelope.resource("textures/gui/letter_tattered_overlay.png");
    protected final ItemAndStack<LetterItem> letter;
    protected final class_1268 hand;
    protected final boolean isTattered;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int maxTextWidth;
    protected int maxTextHeight;
    protected int maxTextLines;
    protected List<class_5481> lines;

    public LetterViewScreen(class_1799 letter, class_1268 hand) {
        super((class_2561)class_2561.method_43473());
        this.letter = new ItemAndStack(letter);
        this.hand = hand;
        this.isTattered = letter.method_57826(Envelope.DataComponents.LETTER_TATTERED);
    }

    public boolean method_25421() {
        return (Boolean)Config.Server.LETTER_PAUSE.get();
    }

    protected void method_25426() {
        this.imageWidth = 176;
        this.imageHeight = 192;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.maxTextWidth = 142;
        this.maxTextHeight = 144;
        Objects.requireNonNull(this.field_22793);
        this.maxTextLines = this.maxTextHeight / 9;
        this.createLines(((LetterContent)this.letter.method_57825(Envelope.DataComponents.LETTER_CONTENT, LetterContent.EMPTY)).text());
    }

    protected void createLines(class_2561 text) {
        this.lines = this.field_22793.method_1728((class_5348)text, this.maxTextWidth);
        if (this.lines.size() > this.maxTextLines) {
            this.lines = new ArrayList<class_5481>(this.lines);
            int lastLineIndex = this.maxTextLines - 1;
            class_5481 ellipsis = class_5244.field_39678.method_30937();
            this.lines.set(lastLineIndex, class_5481.method_30742((class_5481)this.lines.get(lastLineIndex), (class_5481)ellipsis));
            this.lines.set(lastLineIndex + 1, class_5481.method_30742((class_5481)ellipsis, (class_5481)this.lines.get(lastLineIndex + 1)));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_2583 style;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.leftPos + 17;
        int y = this.topPos + 21;
        int textColor = -8693443;
        for (int i = 0; i < Math.min(this.lines.size(), this.maxTextLines); ++i) {
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51430(this.field_22793, this.lines.get(i), x, y + i * 9, textColor, false);
        }
        if (this.isTattered) {
            RenderSystem.enableBlend();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            guiGraphics.method_25302(TATTERED_OVERLAY, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            guiGraphics.method_51448().method_22909();
            RenderSystem.disableBlend();
        }
        if ((style = this.getComponentStyleAt(mouseX, mouseY)) != null && style.method_10969() != null) {
            guiGraphics.method_51441(this.field_22793, style, mouseX, mouseY);
        } else if (this.lines.size() > this.maxTextLines && mouseX >= x && mouseX < x + this.maxTextWidth && mouseY >= y && mouseY < y + this.maxTextHeight) {
            List leftovers = this.lines.stream().skip(this.maxTextLines).toList();
            guiGraphics.method_51447(this.field_22793, leftovers, mouseX, mouseY);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        class_2960 texture = this.isTattered ? TATTERED_TEXTURE : REGULAR_TEXTURE;
        guiGraphics.method_25302(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Nullable
    public class_2583 getComponentStyleAt(double mouseX, double mouseY) {
        if (this.lines.isEmpty() || mouseX < (double)(this.leftPos + 17) || mouseX >= (double)(this.leftPos + 17 + this.maxTextWidth) || mouseY < (double)(this.topPos + 21) || mouseY >= (double)(this.topPos + 21 + this.maxTextHeight)) {
            return null;
        }
        int x = (int)mouseX - (this.leftPos + 17);
        int y = (int)mouseY - (this.topPos + 21);
        int linesCount = Math.min(this.lines.size(), this.maxTextLines);
        Objects.requireNonNull(this.field_22793);
        if (y < 9 * linesCount + linesCount) {
            Objects.requireNonNull(this.field_22793);
            int clickedLine = y / 9;
            if (clickedLine >= 0 && clickedLine < this.lines.size()) {
                class_5481 text = this.lines.get(clickedLine);
                return this.field_22793.method_27527().method_30876(text, x);
            }
            return null;
        }
        return null;
    }

    public void method_25419() {
        super.method_25419();
        int slot = this.hand == class_1268.field_5808 ? Minecrft.player().method_31548().field_7545 : 40;
        Packets.sendToServer(new LetterViewScreenClosedS2CP(slot));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double x, double y, int button) {
        class_2583 style;
        if (button == 0 && this.method_25430(style = this.getComponentStyleAt(x, y))) {
            return true;
        }
        return super.method_25402(x, y, button);
    }

    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        @Nullable class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        boolean handled = this.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }
}

